/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Writer;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.internal.ByteStringWriter;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.render.Decimaliser;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.scoped.ScopedResource;
import org.jetbrains.annotations.NotNull;

public interface ByteStringAppender<B extends ByteStringAppender<B>>
extends StreamingDataOutput<B>,
Appendable {
    @NotNull
    default public Writer writer() {
        return new ByteStringWriter(this);
    }

    @NotNull
    default public B append(char ch) throws IllegalStateException {
        BytesInternal.appendUtf8Char(this, ch);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs) {
        if (cs.length() == 0) {
            return (B)this;
        }
        return (B)this.append(cs, 0, cs.length());
    }

    @NotNull
    default public B append(boolean flag) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return (B)this.append(flag ? (char)'T' : 'F');
    }

    @NotNull
    default public B append(int value) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.appendBase10(this, value);
        return (B)this;
    }

    @NotNull
    default public B append(long value) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (value == (long)((int)value)) {
            BytesInternal.appendBase10(this, (int)value);
        } else {
            BytesInternal.appendBase10(this, value);
        }
        return (B)this;
    }

    @NotNull
    default public B appendBase(long value, int base) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (base == 10) {
            this.append(value);
        } else {
            BytesInternal.append(this, value, base);
        }
        return (B)this;
    }

    @NotNull
    default public B appendBase16(long value) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.appendBase16(this, value, 1);
        return (B)this;
    }

    @NotNull
    default public B appendBase16(long value, int minDigits) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        BytesInternal.appendBase16(this, value, minDigits);
        return (B)this;
    }

    @NotNull
    default public B appendDecimal(long value, int decimalPlaces) throws BufferOverflowException, IllegalStateException, IllegalArgumentException {
        BytesInternal.appendDecimal(this, value, decimalPlaces);
        return (B)this;
    }

    @NotNull
    default public B append(float f) throws BufferOverflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException {
        float f2 = Math.abs(f);
        if ((double)f2 > 1000000.0 || (double)f2 < 0.001) {
            return (B)this.append(Float.toString(f));
        }
        int precision = (int)Math.floor(6.0 - Math.log10(f2));
        long tens = Maths.tens((int)precision);
        return this.append((double)Math.round(f * (float)tens) / (double)tens);
    }

    @NotNull
    default public B append(double d) throws BufferOverflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try (ScopedResource<Bytes<?>> stlBytes = BytesInternal.acquireBytesScoped();){
            Bytes bytes = (Bytes)stlBytes.get();
            bytes.append(d);
            this.append(bytes);
            ByteStringAppender byteStringAppender = this;
            return (B)byteStringAppender;
        }
    }

    public Decimaliser decimaliser();

    public B decimaliser(Decimaliser var1);

    public boolean fpAppend0();

    public B fpAppend0(boolean var1);

    @NotNull
    default public B append(double d, int decimalPlaces) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.append(this, d, decimalPlaces);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs, @NonNegative int start, @NonNegative int end) throws IndexOutOfBoundsException {
        BytesInternal.appendUtf8(this, cs, start, end - start);
        return (B)this;
    }

    @NotNull
    default public B append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.append8bit(cs, 0, cs.length());
    }

    default public B append8bit(@NotNull BytesStore bs) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return (B)((ByteStringAppender)this.write(bs, 0L, bs.readRemaining()));
    }

    default public B append8bit(@NotNull String cs) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.append8bit(cs, 0, cs.length());
    }

    default public B append8bit(@NotNull CharSequence cs, @NonNegative int start, @NonNegative int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (!1.$assertionsDisabled && end < start) {
            throw new AssertionError((Object)("end=" + end + ",start=" + start));
        }
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs, (long)start, (long)(end - start)));
        }
        for (int i = start; i < end; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte((byte)c);
        }
        return (B)this;
    }

    default public B append8bit(@NotNull BytesStore bs, @NonNegative long start, @NonNegative long end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (!1.$assertionsDisabled && end <= start) {
            throw new AssertionError((Object)("end=" + end + ",start=" + start));
        }
        return (B)((ByteStringAppender)this.write(bs, start, end - start));
    }

    @NotNull
    default public B appendDateMillis(long dateInMillis) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.appendDateMillis(this, dateInMillis);
        return (B)this;
    }

    @NotNull
    default public B appendTimeMillis(long timeOfDayInMillis) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesInternal.appendTimeMillis(this, timeOfDayInMillis % 86400000L);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull BigDecimal bigDecimal) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.append(bigDecimal.toString());
        return (B)this;
    }

    @Override
    @Deprecated
    public byte[] internalNumberBuffer();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

