/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.FileLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.CanonicalPathUtil;
import net.openhft.chronicle.bytes.internal.ChunkedMappedFile;
import net.openhft.chronicle.bytes.internal.SingleMappedFile;
import net.openhft.chronicle.core.CleaningRandomAccessFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractCloseableReferenceCounted;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MappedFile
extends AbstractCloseableReferenceCounted {
    public static final SyncMode DEFAULT_SYNC_MODE = SyncMode.valueOf(System.getProperty("mappedFile.defaultSyncMode", "ASYNC"));
    protected static final boolean RETAIN = Jvm.getBoolean((String)"mappedFile.retain");
    private static final long DEFAULT_CAPACITY = 0x800000000000L;
    private final String internalizedToken;
    @NotNull
    private final File file;
    private final boolean readOnly;
    protected NewChunkListener newChunkListener = MappedFile::logNewChunk;

    protected MappedFile(@NotNull File file, boolean readOnly) throws IORuntimeException {
        this.file = file;
        this.internalizedToken = CanonicalPathUtil.of(file);
        this.readOnly = readOnly;
    }

    static void logNewChunk(String filename, @NonNegative int chunk, long delayMicros) {
        if (delayMicros < 100L || !Jvm.isDebugEnabled(MappedFile.class)) {
            return;
        }
        String message = BytesInternal.acquireStringBuilder().append("Allocation of ").append(chunk).append(" chunk in ").append(filename).append(" took ").append((double)delayMicros / 1000.0).append(" ms.").toString();
        Jvm.perf().on(ChunkedMappedFile.class, message);
    }

    @NotNull
    public static MappedFile of(@NotNull File file, @NonNegative long chunkSize, @NonNegative long overlapSize, boolean readOnly) throws FileNotFoundException {
        @NotNull CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, readOnly ? "r" : "rw");
        long capacity = 0x800000000000L;
        return new ChunkedMappedFile(file, (RandomAccessFile)raf, chunkSize, overlapSize, 0x800000000000L, readOnly);
    }

    @NotNull
    public static MappedFile ofSingle(@NotNull File file, @NonNegative long capacity, boolean readOnly) throws FileNotFoundException {
        @NotNull CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, readOnly ? "r" : "rw");
        return new SingleMappedFile(file, (RandomAccessFile)raf, capacity, readOnly);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, @NonNegative long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, @NonNegative long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(filename, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, @NonNegative long chunkSize, @NonNegative long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(new File(filename), chunkSize, overlapSize);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, @NonNegative long chunkSize, @NonNegative long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, overlapSize, false);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, @NonNegative long chunkSize, @NonNegative long overlapSize, boolean readOnly) throws FileNotFoundException {
        return MappedFile.of(file, chunkSize, overlapSize, readOnly);
    }

    @NotNull
    public static MappedFile readOnly(@NotNull File file) throws FileNotFoundException {
        long chunkSize = file.length();
        long overlapSize = 0L;
        if (OS.isWindows() && chunkSize > 0x80000000L) {
            chunkSize = 0x80000000L;
            overlapSize = OS.pageSize();
        }
        return MappedFile.of(file, chunkSize, overlapSize, true);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, @NonNegative long capacity, @NonNegative long chunkSize, @NonNegative long overlapSize, boolean readOnly) throws IOException {
        CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, readOnly ? "r" : "rw");
        if (raf.length() < capacity) {
            raf.setLength(capacity);
        }
        return new ChunkedMappedFile(file, (RandomAccessFile)raf, chunkSize, overlapSize, capacity, readOnly);
    }

    public static void warmup() {
        ChunkedMappedFile.warmup();
    }

    @NotNull
    public File file() {
        return this.file;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    @NotNull
    public MappedBytesStore acquireByteStore(ReferenceOwner owner, @NonNegative long position) throws IOException, IllegalArgumentException, IllegalStateException {
        return this.acquireByteStore(owner, position, null, MappedBytesStore::new);
    }

    @NotNull
    public MappedBytesStore acquireByteStore(ReferenceOwner owner, @NonNegative long position, BytesStore oldByteStore) throws IOException, IllegalStateException {
        return this.acquireByteStore(owner, position, oldByteStore, MappedBytesStore::new);
    }

    @NotNull
    public abstract MappedBytesStore acquireByteStore(ReferenceOwner var1, @NonNegative long var2, BytesStore var4, @NotNull MappedBytesStoreFactory var5) throws IOException, IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException;

    @NotNull
    public Bytes<?> acquireBytesForRead(ReferenceOwner owner, @NonNegative long position) throws IOException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed();
        @Nullable MappedBytesStore mbs = this.acquireByteStore(owner, position, null);
        Bytes<Void> bytes = mbs.bytesForRead();
        bytes.readPositionUnlimited(position);
        bytes.reserveTransfer(INIT, owner);
        mbs.release(owner);
        return bytes;
    }

    public void acquireBytesForRead(ReferenceOwner owner, @NonNegative long position, @NotNull VanillaBytes bytes) throws IOException, IllegalStateException, IllegalArgumentException, BufferUnderflowException, BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed();
        @Nullable MappedBytesStore mbs = this.acquireByteStore(owner, position, null);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
    }

    @NotNull
    public Bytes<?> acquireBytesForWrite(ReferenceOwner owner, @NonNegative long position) throws IOException, ClosedIllegalStateException, IllegalArgumentException, BufferOverflowException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed();
        @Nullable MappedBytesStore mbs = this.acquireByteStore(owner, position, null);
        @NotNull Bytes bytes = mbs.bytesForWrite();
        bytes.writePosition(position);
        bytes.reserveTransfer(INIT, owner);
        mbs.release(owner);
        return bytes;
    }

    public void acquireBytesForWrite(ReferenceOwner owner, @NonNegative long position, @NotNull VanillaBytes bytes) throws IOException, ClosedIllegalStateException, IllegalArgumentException, BufferUnderflowException, BufferOverflowException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed();
        @Nullable MappedBytesStore mbs = this.acquireByteStore(owner, position, null);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
        bytes.writePosition(position);
    }

    protected boolean canReleaseInBackground() {
        return true;
    }

    @NotNull
    public abstract String referenceCounts();

    public abstract long capacity();

    public abstract long chunkSize();

    public abstract long overlapSize();

    public NewChunkListener getNewChunkListener() {
        return this.newChunkListener;
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.newChunkListener = listener;
    }

    public abstract long actualSize();

    @NotNull
    public abstract RandomAccessFile raf();

    protected void finalize() throws Throwable {
        this.warnAndReleaseIfNotReleased();
        super.finalize();
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    protected String internalizedToken() {
        return this.internalizedToken;
    }

    public abstract FileLock lock(@NonNegative long var1, @NonNegative long var3, boolean var5) throws IOException;

    public abstract FileLock tryLock(@NonNegative long var1, @NonNegative long var3, boolean var5) throws IOException;

    public abstract long chunkCount();

    public abstract void chunkCount(long[] var1);

    public abstract MappedBytes createBytesFor() throws ClosedIllegalStateException;

    public abstract void syncMode(SyncMode var1);
}

