/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ReferenceCounted;
import org.jetbrains.annotations.NotNull;

interface RandomCommon
extends ReferenceCounted {
    @NonNegative
    default public long start() {
        return 0L;
    }

    @NonNegative
    default public long capacity() {
        return 0x7FFFFFFFFFFFFFF0L;
    }

    @NonNegative
    default public long realCapacity() {
        return this.capacity();
    }

    @NonNegative
    default public long readPosition() {
        return this.start();
    }

    @NonNegative
    default public long writePosition() {
        return this.start();
    }

    default public long lengthWritten(@NonNegative long startPosition) {
        return this.writePosition() - startPosition;
    }

    default public long readRemaining() {
        return this.readLimit() - this.readPosition();
    }

    default public long realReadRemaining() {
        return Math.min(this.realCapacity(), this.readLimit()) - this.readPosition();
    }

    default public long writeRemaining() {
        return this.writeLimit() - this.writePosition();
    }

    default public long realWriteRemaining() {
        return Math.min(this.realCapacity(), this.writeLimit()) - this.writePosition();
    }

    @NonNegative
    default public long readLimit() {
        return this.realCapacity();
    }

    @NonNegative
    default public long writeLimit() {
        return this.realCapacity();
    }

    public long addressForRead(@NonNegative long var1) throws UnsupportedOperationException, BufferUnderflowException, IllegalStateException;

    default public long addressForRead(@NonNegative long offset, @NonNegative int buffer) throws UnsupportedOperationException, BufferUnderflowException, IllegalStateException {
        return this.addressForRead(offset);
    }

    public long addressForWrite(@NonNegative long var1) throws UnsupportedOperationException, BufferOverflowException, IllegalStateException;

    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException, IllegalStateException;

    default public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    @NotNull
    public Bytes<?> bytesForRead() throws IllegalStateException;

    @NotNull
    public Bytes<?> bytesForWrite() throws IllegalStateException;

    public boolean compareAndSwapInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, IllegalStateException;

    public void testAndSetInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, IllegalStateException;

    public boolean compareAndSwapLong(@NonNegative long var1, long var3, long var5) throws BufferOverflowException, IllegalStateException;

    default public boolean compareAndSwapFloat(@NonNegative long offset, float expected, float value) throws BufferOverflowException, IllegalStateException {
        return this.compareAndSwapInt(offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(value));
    }

    default public boolean compareAndSwapDouble(@NonNegative long offset, double expected, double value) throws BufferOverflowException, IllegalStateException {
        return this.compareAndSwapLong(offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(value));
    }

    public boolean sharedMemory();

    public boolean isDirectMemory();
}

