/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractReference
extends AbstractCloseable
implements Byteable,
Closeable {
    @Nullable
    protected BytesStore<?, ?> bytes;
    protected long offset;

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        this.acceptNewBytesStore(bytes);
        this.offset = offset;
    }

    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public abstract long maxSize();

    protected void acceptNewBytesStore(@NotNull BytesStore bytes) throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release((ReferenceOwner)this);
        }
        this.bytes = bytes.bytesStore();
        this.bytes.reserve((ReferenceOwner)this);
    }

    protected void performClose() throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release((ReferenceOwner)this);
            this.bytes = null;
        }
    }

    public long address() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore().addressForRead(this.offset);
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

