/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public enum MappedUniqueTimeProvider implements TimeProvider
{
    INSTANCE;

    private static final int LAST_TIME = 128;
    private final MappedFile file;
    private final Bytes bytes;
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    private MappedUniqueTimeProvider() {
        try {
            String user = System.getProperty("user.name", "unknown");
            this.file = MappedFile.mappedFile(OS.TMP + "/.time-stamp." + user + ".dat", (long)OS.pageSize(), 0L);
            IOTools.unmonitor((Object)((Object)this.file));
            ReferenceOwner mumtp = ReferenceOwner.temporary((String)"mumtp");
            this.bytes = this.file.acquireBytesForWrite(mumtp, 0L);
            this.bytes.append8bit("&TSF\nTime stamp file uses for sharing a unique id\n");
            IOTools.unmonitor((Object)this.bytes);
        }
        catch (Exception ioe) {
            throw new IORuntimeException((Throwable)ioe);
        }
    }

    public MappedUniqueTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        return this;
    }

    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    public long currentTimeMicros() throws IllegalStateException {
        long timeus = this.provider.currentTimeMicros();
        try {
            while (true) {
                long time0us;
                long time;
                long time0;
                if (this.bytes.compareAndSwapLong(128L, time0, time = (time0us = (time0 = this.bytes.readVolatileLong(128L)) / 1000L) >= timeus ? (time0us + 1L) * 1000L : timeus * 1000L)) {
                    return time / 1000L;
                }
                Jvm.nanoPause();
            }
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long currentTimeNanos() throws IllegalStateException {
        try {
            long time = this.provider.currentTimeNanos();
            long time5 = time >>> 5;
            long time0 = this.bytes.readVolatileLong(128L);
            long timeNanos5 = time0 >>> 5;
            if (time5 > timeNanos5 && this.bytes.compareAndSwapLong(128L, time0, time)) {
                return time;
            }
            while (true) {
                long next;
                if (this.bytes.compareAndSwapLong(128L, time0 = this.bytes.readVolatileLong(128L), next = time0 + 32L & 0xFFFFFFFFFFFFFFE0L)) {
                    return next;
                }
                Jvm.nanoPause();
            }
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }
}

