/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;

public enum NoBytesStore implements BytesStore
{
    NO_BYTES_STORE;

    public static final long NO_PAGE;
    @NotNull
    public static final Bytes NO_BYTES;

    @NotNull
    public static <T, B extends BytesStore<B, T>> BytesStore<B, T> noBytesStore() {
        return NO_BYTES_STORE;
    }

    public void reserve(ReferenceOwner owner) throws IllegalStateException {
    }

    public void release(ReferenceOwner owner) throws IllegalStateException {
    }

    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
    }

    public int refCount() {
        return 1;
    }

    public boolean tryReserve(ReferenceOwner owner) {
        return false;
    }

    public boolean reservedBy(ReferenceOwner owner) {
        return true;
    }

    @Override
    @NotNull
    public RandomDataOutput writeByte(long offset, byte i8) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeShort(long offset, short i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeInt(long offset, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeOrderedInt(long offset, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeLong(long offset, long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeOrderedLong(long offset, long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeFloat(long offset, float d) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeDouble(long offset, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileByte(long offset, byte i8) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileShort(long offset, short i16) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileInt(long offset, int i32) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileLong(long offset, long i64) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput write(long offsetInRDO, byte[] bytes, int offset, int length) {
        if (length != 0) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) {
        if (length != 0) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    @NotNull
    public RandomDataOutput write(long writeOffset, RandomDataInput bytes, long readOffset, long length) {
        if (length != 0L) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public byte readByte(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int peekUnsignedByte(long offset) {
        return -1;
    }

    @Override
    public short readShort(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readInt(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double readDouble(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        throw new BufferUnderflowException();
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @NotNull
    public BytesStore copy() {
        return this;
    }

    @Override
    public long capacity() {
        return 0L;
    }

    public Void underlyingObject() {
        return null;
    }

    @Override
    public boolean inside(long offset) {
        return false;
    }

    @Override
    public boolean inside(long offset, long buffer) {
        return false;
    }

    @Override
    public long copyTo(BytesStore store) {
        return 0L;
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equalBytes(BytesStore bytesStore, long length) {
        return length == 0L;
    }

    @Override
    public void move(long from, long to, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException {
        if (offset != 0L) {
            throw new BufferUnderflowException();
        }
        return NO_PAGE;
    }

    @Override
    public long addressForWrite(long offset) throws BufferOverflowException {
        if (offset != 0L) {
            throw new BufferOverflowException();
        }
        return NO_PAGE;
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        return NO_PAGE;
    }

    @Override
    @NotNull
    public Bytes bytesForWrite() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    static {
        try {
            NO_PAGE = OS.memory().allocate((long)OS.pageSize());
            NO_BYTES = new VanillaBytes(NoBytesStore.noBytesStore());
            AbstractReferenceCounted.unmonitor((ReferenceCounted)NO_BYTES);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
    }
}

