/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.pool;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import org.jetbrains.annotations.NotNull;

public class BytesPool {
    final ThreadLocal<Bytes> bytesTL = new ThreadLocal();

    public Bytes acquireBytes() {
        Bytes bytes = this.bytesTL.get();
        if (bytes == null) {
            bytes = this.createBytes();
            this.bytesTL.set(bytes);
        } else {
            bytes.clear();
        }
        return bytes;
    }

    @NotNull
    protected Bytes createBytes() {
        Bytes<ByteBuffer> bbb = Bytes.elasticHeapByteBuffer(256);
        AbstractReferenceCounted.unmonitor(bbb);
        return bbb;
    }
}

