/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;

public class MappedBytesStore
extends NativeBytesStore<Void> {
    private final MappedFile mappedFile;
    private final long start;
    private final long safeLimit;

    protected MappedBytesStore(ReferenceOwner owner, MappedFile mappedFile, long start, long address, long capacity, long safeCapacity) throws IllegalStateException {
        super(address, start + capacity, (Runnable)new OS.Unmapper(address, capacity), false);
        this.mappedFile = mappedFile;
        this.start = start;
        this.safeLimit = start + safeCapacity;
        this.reserveTransfer(INIT, owner);
    }

    @Override
    @NotNull
    public VanillaBytes<Void> bytesForWrite() throws IllegalStateException {
        return new VanillaBytes<Void>(this);
    }

    @Override
    public boolean inside(long offset) {
        return this.start <= offset && offset < this.safeLimit;
    }

    @Override
    public boolean inside(long offset, long buffer) {
        return this.start <= offset && offset + buffer < this.maximumLimit;
    }

    @Override
    public long safeLimit() {
        return this.safeLimit;
    }

    @Override
    public byte readByte(long offset) {
        return this.memory.readByte(this.address - this.start + offset);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeOrderedInt(long offset, int i) {
        this.memory.writeOrderedInt(this.address - this.start + offset, i);
        return this;
    }

    @Override
    protected long translate(long offset) {
        assert (offset >= this.start);
        assert (offset < this.maximumLimit);
        return offset - this.start;
    }

    @Override
    public long start() {
        return this.start;
    }

    @Override
    public long readPosition() {
        return this.start();
    }
}

