/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.util.function.IntSupplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;

public class TextIntReference
extends AbstractReference
implements IntValue {
    private static final byte[] template = "!!atomic {  locked: false, value: 0000000000 }".getBytes(StandardCharsets.ISO_8859_1);
    private static final int FALSE = 1936482662;
    private static final int TRUE = 1970435104;
    private static final int UNINITIALIZED = 0;
    private static final int INT_TRUE = 1;
    private static final int INT_FALSE = 0;
    private static final int LOCKED = 20;
    private static final int VALUE = 34;
    private static final int DIGITS = 10;

    public static void write(@NotNull Bytes bytes, int value) throws BufferOverflowException {
        long position = bytes.writePosition();
        bytes.write(template);
        try {
            bytes.append(position + 34L, value, 10);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private int withLock(@NotNull IntSupplier call) throws BufferUnderflowException {
        long alignedOffset = BytesUtil.roundUpTo8ByteAlign(this.offset);
        long lockValueOffset = alignedOffset + 20L;
        int lockValue = this.bytes.readVolatileInt(lockValueOffset);
        if (lockValue != 1936482662 && lockValue != 1970435104) {
            throw new IllegalStateException();
        }
        try {
            while (!this.bytes.compareAndSwapInt(lockValueOffset, 1936482662, 1970435104)) {
            }
            int t = call.getAsInt();
            this.bytes.writeOrderedInt(lockValueOffset, 1936482662);
            return t;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getValue() {
        return this.withLock(() -> (int)this.bytes.parseLong(this.offset + 34L));
    }

    public void setValue(int value) {
        this.withLock(() -> {
            this.bytes.append(this.offset + 34L, value, 10);
            return 1;
        });
    }

    public int getVolatileValue() {
        return this.getValue();
    }

    public void setOrderedValue(int value) {
        this.setValue(value);
    }

    public int addValue(int delta) {
        return this.withLock(() -> {
            long value = this.bytes.parseLong(this.offset + 34L) + (long)delta;
            this.bytes.append(this.offset + 34L, value, 10);
            return (int)value;
        });
    }

    public int addAtomicValue(int delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(int expected, int value) {
        return this.withLock(() -> {
            if (this.bytes.parseLong(this.offset + 34L) == (long)expected) {
                this.bytes.append(this.offset + 34L, value, 10);
                return 1;
            }
            return 0;
        }) == 1;
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != (long)template.length) {
            throw new IllegalArgumentException(length + " != " + template.length);
        }
        long newOffset = BytesUtil.roundUpTo8ByteAlign(offset);
        for (long i = offset; i < newOffset; ++i) {
            bytes.writeByte(i, (byte)32);
        }
        super.bytesStore(bytes, newOffset, length);
        if (bytes.readInt(newOffset) == 0) {
            bytes.write(newOffset, template);
        }
    }

    @Override
    public long maxSize() {
        return template.length;
    }

    @NotNull
    public String toString() {
        return "value: " + this.getValue();
    }
}

