/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMethodReader;
import net.openhft.chronicle.bytes.BytesParselet;
import net.openhft.chronicle.bytes.MethodEncoderLookup;
import net.openhft.chronicle.bytes.MethodReaderBuilder;
import net.openhft.chronicle.bytes.MethodReaderInterceptor;
import org.jetbrains.annotations.NotNull;

public class BytesMethodReaderBuilder
implements MethodReaderBuilder {
    private final BytesIn in;
    private BytesParselet defaultParselet = BytesMethodReaderBuilder.createDefaultParselet();
    private MethodEncoderLookup methodEncoderLookup = MethodEncoderLookup.BY_ANNOTATION;

    public BytesMethodReaderBuilder(BytesIn in) {
        this.in = in;
    }

    @NotNull
    static BytesParselet createDefaultParselet() {
        return (msg, in) -> {
            Bytes bytes = (Bytes)in;
            throw new IllegalArgumentException("Unknown message type " + msg + " " + bytes.toHexString());
        };
    }

    @Override
    public MethodReaderBuilder warnMissing(boolean warnMissing) {
        return this;
    }

    public MethodEncoderLookup methodEncoderLookup() {
        return this.methodEncoderLookup;
    }

    public BytesMethodReaderBuilder methodEncoderLookup(MethodEncoderLookup methodEncoderLookup) {
        this.methodEncoderLookup = methodEncoderLookup;
        return this;
    }

    public BytesParselet defaultParselet() {
        return this.defaultParselet;
    }

    public BytesMethodReaderBuilder defaultParselet(BytesParselet defaultParselet) {
        this.defaultParselet = defaultParselet;
        return this;
    }

    @Override
    public MethodReaderBuilder methodReaderInterceptor(MethodReaderInterceptor methodReaderInterceptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytesMethodReader build(Object ... objects) {
        return new BytesMethodReader(this.in, this.defaultParselet, this.methodEncoderLookup, objects);
    }
}

