/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.StreamingDataInput;
import org.jetbrains.annotations.NotNull;

public class StreamingInputStream
extends InputStream {
    private StreamingDataInput in;

    public StreamingInputStream() {
        this(NoBytesStore.NO_BYTES);
    }

    public StreamingInputStream(StreamingDataInput in) {
        this.in = in;
    }

    @NotNull
    public StreamingInputStream init(StreamingDataInput in) {
        this.in = in;
        return this;
    }

    @Override
    public long skip(long n) throws IOException {
        long len = Math.min(this.in.readRemaining(), n);
        this.in.readSkip(len);
        return len;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.in.readRemaining());
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int len2 = this.in.read(b, off, len);
        return len2 == 0 ? -1 : len2;
    }

    @Override
    public int read() throws IOException {
        return this.in.readRemaining() > 0L ? this.in.readUnsignedByte() : -1;
    }
}

