/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Method;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.MethodEncoder;
import net.openhft.chronicle.bytes.MethodId;

public enum MethodEncoderLookup implements Function<Method, MethodEncoder>
{
    BY_ANNOTATION;


    @Override
    public MethodEncoder apply(Method method) {
        MethodId methodId = method.getAnnotation(MethodId.class);
        if (methodId == null && (methodId = this.findAnnotation(method.getDeclaringClass(), method.getName(), method.getParameterTypes())) == null) {
            return null;
        }
        final long messageId = methodId.value();
        return new MethodEncoder(){

            @Override
            public long messageId() {
                return messageId;
            }

            @Override
            public void encode(Object[] objects, BytesOut out) {
                for (Object object : objects) {
                    if (!(object instanceof BytesMarshallable)) {
                        throw new IllegalArgumentException("Object type " + object + " not supported");
                    }
                    ((BytesMarshallable)object).writeMarshallable(out);
                }
            }

            @Override
            public Object[] decode(Object[] lastObjects, BytesIn in) {
                for (int i = 0; i < lastObjects.length; ++i) {
                    ((BytesMarshallable)lastObjects[i]).readMarshallable(in);
                }
                return lastObjects;
            }
        };
    }

    private MethodId findAnnotation(Class<?> aClass, String name, Class<?>[] parameterTypes) {
        MethodId methodId = null;
        try {
            Method m = aClass.getMethod(name, parameterTypes);
            methodId = m.getAnnotation(MethodId.class);
            if (methodId != null) {
                return methodId;
            }
        }
        catch (NoSuchMethodException m) {
            // empty catch block
        }
        Class<?> superclass = aClass.getSuperclass();
        if (superclass != null && superclass != Object.class && (methodId = this.findAnnotation(superclass, name, parameterTypes)) != null) {
            return methodId;
        }
        for (Class<?> iClass : aClass.getInterfaces()) {
            methodId = this.findAnnotation(iClass, name, parameterTypes);
            if (methodId == null) continue;
            return methodId;
        }
        return null;
    }

    private MethodId findAnnotation(Class aClass, Method method, Class<MethodId> methodIdClass) {
        return null;
    }
}

