/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.ByteableLongArrayValues;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.values.LongValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextLongArrayReference
implements ByteableLongArrayValues {
    private static final byte[] SECTION1 = "{ locked: false, capacity: ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION2 = ", used: ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION3 = ", values: [ ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION4 = " ] }\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ZERO = "00000000000000000000".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SEP = ", ".getBytes(StandardCharsets.ISO_8859_1);
    private static final int DIGITS = ZERO.length;
    private static final int CAPACITY = SECTION1.length;
    private static final int USED = CAPACITY + DIGITS + SECTION2.length;
    private static final int VALUES = USED + DIGITS + SECTION3.length;
    private static final int VALUE_SIZE = DIGITS + SEP.length;
    private static final int LOCK_OFFSET = 10;
    private static final int FALS = 1936482662;
    private static final int TRU = 1970435104;
    @Nullable
    private BytesStore bytes;
    private long offset;
    private long length = VALUES;

    public static void write(@NotNull Bytes bytes, long capacity) {
        long start = bytes.writePosition();
        bytes.write(SECTION1);
        bytes.append(capacity);
        while (bytes.writePosition() - start < (long)(CAPACITY + DIGITS)) {
            bytes.writeUnsignedByte(32);
        }
        bytes.write(SECTION2);
        bytes.write(ZERO);
        bytes.write(SECTION3);
        for (long i = 0L; i < capacity; ++i) {
            if (i > 0L) {
                bytes.appendUtf8(", ");
            }
            bytes.write(ZERO);
        }
        bytes.write(SECTION4);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) {
        return bytes.parseLong(offset + (long)CAPACITY) * (long)VALUE_SIZE - (long)SEP.length + (long)VALUES + (long)SECTION4.length;
    }

    public long getUsed() {
        return this.bytes.parseLong((long)USED + this.offset);
    }

    private void setUsed(long used) {
        this.bytes.append((long)VALUES + this.offset, used, DIGITS);
    }

    public void setMaxUsed(long usedAtLeast) {
        while (!this.bytes.compareAndSwapInt(10L + this.offset, 1936482662, 1970435104)) {
        }
        try {
            if (this.getUsed() < usedAtLeast) {
                this.setUsed(usedAtLeast);
            }
            return;
        }
        finally {
            this.bytes.writeInt(10L + this.offset, 1936482662);
        }
    }

    public long getCapacity() {
        return (this.length - (long)VALUES) / (long)VALUE_SIZE;
    }

    public long getValueAt(long index) {
        return this.bytes.parseLong((long)VALUES + this.offset + index * (long)VALUE_SIZE);
    }

    public void setValueAt(long index, long value) {
        this.bytes.append((long)VALUES + this.offset + index * (long)VALUE_SIZE, value, DIGITS);
    }

    public void bindValueAt(int index, LongValue value) {
        throw new UnsupportedOperationException("todo");
    }

    public long getVolatileValueAt(long index) {
        OS.memory().loadFence();
        return this.getValueAt(index);
    }

    public void setOrderedValueAt(long index, long value) {
        this.setValueAt(index, value);
        OS.memory().storeFence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(long index, long expected, long value) {
        if (!this.bytes.compareAndSwapInt(10L + this.offset, 1936482662, 1970435104)) {
            return false;
        }
        boolean ret = false;
        try {
            if (this.getVolatileValueAt(index) == expected) {
                this.setOrderedValueAt(index, value);
                ret = true;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.bytes.writeInt(10L + this.offset, 1936482662);
        }
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != TextLongArrayReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + TextLongArrayReference.peakLength(bytes, offset));
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public void reset() {
        this.bytes = null;
        this.offset = 0L;
        this.length = 0L;
    }

    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "LongArrayTextReference{bytes=null, offset=" + this.offset + ", length=" + this.length + '}';
        }
        return "value: " + this.getValueAt(0L) + " ...";
    }

    @Override
    public long sizeInBytes(long capacity) {
        return capacity * (long)VALUE_SIZE + (long)VALUES + (long)SECTION3.length - (long)SEP.length;
    }
}

