/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedFile
implements ReferenceCounted {
    public static final long DEFAULT_CAPACITY = 0x10000000000L;
    private static final Object GLOBAL_FILE_LOCK = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(MappedFile.class);
    @NotNull
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final long chunkSize;
    private final long overlapSize;
    private final List<WeakReference<MappedBytesStore>> stores = new ArrayList<WeakReference<MappedBytesStore>>();
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final long capacity;
    @NotNull
    private final File file;
    private NewChunkListener newChunkListener = null;

    protected MappedFile(@NotNull File file, @NotNull RandomAccessFile raf, long chunkSize, long overlapSize, long capacity) {
        this.file = file;
        this.raf = raf;
        this.fileChannel = raf.getChannel();
        this.chunkSize = OS.mapAlign((long)chunkSize);
        this.overlapSize = OS.mapAlign((long)overlapSize);
        this.capacity = capacity;
    }

    public static MappedFile of(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        return new MappedFile(file, raf, chunkSize, overlapSize, 0x10000000000L);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(filename, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, long chunkSize, long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(new File(filename), chunkSize, overlapSize);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException {
        return MappedFile.of(file, chunkSize, overlapSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedFile withSizes(long chunkSize, long overlapSize) {
        chunkSize = OS.mapAlign((long)chunkSize);
        overlapSize = OS.mapAlign((long)overlapSize);
        if (chunkSize == this.chunkSize && overlapSize == this.overlapSize) {
            return this;
        }
        try {
            MappedFile mappedFile = new MappedFile(this.file, this.raf, chunkSize, overlapSize, this.capacity);
            return mappedFile;
        }
        finally {
            this.release();
        }
    }

    public File file() {
        return this.file;
    }

    @Nullable
    public MappedBytesStore acquireByteStore(long position) throws IOException, IllegalArgumentException, IllegalStateException {
        return this.acquireByteStore(position, MappedBytesStore::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends MappedBytesStore> T acquireByteStore(long position, MappedBytesStoreFactory<T> mappedBytesStoreFactory) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.closed.get()) {
            throw new IOException("Closed");
        }
        if (position < 0L) {
            throw new IOException("Attempt to access a negative position: " + position);
        }
        int chunk = (int)(position / this.chunkSize);
        List<WeakReference<MappedBytesStore>> list = this.stores;
        synchronized (list) {
            MappedBytesStore mbs;
            while (this.stores.size() <= chunk) {
                this.stores.add(null);
            }
            WeakReference<MappedBytesStore> mbsRef = this.stores.get(chunk);
            if (mbsRef != null && (mbs = (MappedBytesStore)mbsRef.get()) != null && mbs.tryReserve()) {
                return (T)mbs;
            }
            long minSize = ((long)chunk + 1L) * this.chunkSize + this.overlapSize;
            long size = this.fileChannel.size();
            if (size < minSize) {
                try {
                    Object object = GLOBAL_FILE_LOCK;
                    synchronized (object) {
                        try (FileLock lock = this.fileChannel.lock();){
                            size = this.fileChannel.size();
                            if (size < minSize) {
                                this.raf.setLength(minSize);
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new IORuntimeException("Failed to resize to " + minSize, (Throwable)ioe);
                }
            }
            long start = System.nanoTime();
            long mappedSize = this.chunkSize + this.overlapSize;
            long address = OS.map((FileChannel)this.fileChannel, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)((long)chunk * this.chunkSize), (long)mappedSize);
            T mbs2 = mappedBytesStoreFactory.create(this, (long)chunk * this.chunkSize, address, mappedSize, this.chunkSize);
            this.stores.set(chunk, new WeakReference<T>(mbs2));
            ((NativeBytesStore)mbs2).reserve();
            if (this.newChunkListener != null) {
                this.newChunkListener.onNewChunk(this.file.getPath(), chunk, (System.nanoTime() - start) / 1000L);
            }
            return mbs2;
        }
    }

    public Bytes acquireBytesForRead(long position) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        Bytes bytes = mbs.bytesForRead();
        bytes.readPosition(position);
        mbs.release();
        return bytes;
    }

    public void acquireBytesForRead(long position, @NotNull VanillaBytes bytes) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
    }

    public Bytes acquireBytesForWrite(long position) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        Bytes bytes = mbs.bytesForWrite();
        bytes.writePosition(position);
        mbs.release();
        return bytes;
    }

    public void acquireBytesForWrite(long position, @NotNull VanillaBytes bytes) throws IOException, IllegalStateException, IllegalArgumentException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
        bytes.writePosition(position);
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            List<WeakReference<MappedBytesStore>> list = this.stores;
            synchronized (list) {
                ReferenceCounted.releaseAll(this.stores);
            }
            this.release();
        }
        catch (IllegalStateException e) {
            LOG.error("", (Throwable)e);
        }
    }

    private void performRelease() {
        for (int i = 0; i < this.stores.size(); ++i) {
            long count;
            WeakReference<MappedBytesStore> storeRef = this.stores.get(i);
            if (storeRef == null) continue;
            MappedBytesStore mbs = (MappedBytesStore)storeRef.get();
            if (mbs != null && (count = mbs.refCount()) > 0L) {
                try {
                    mbs.release();
                }
                catch (IllegalStateException e) {
                    LOG.error("", (Throwable)e);
                }
                if (count > 1L) continue;
            }
            this.stores.set(i, null);
        }
        try {
            this.raf.close();
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @NotNull
    public String referenceCounts() {
        StringBuilder sb = new StringBuilder();
        sb.append("refCount: ").append(this.refCount());
        for (WeakReference<MappedBytesStore> store : this.stores) {
            MappedBytesStore mbs;
            long count = 0L;
            if (store != null && (mbs = (MappedBytesStore)store.get()) != null) {
                count = mbs.refCount();
            }
            sb.append(", ").append(count);
        }
        return sb.toString();
    }

    public long capacity() {
        return this.capacity;
    }

    public long chunkSize() {
        return this.chunkSize;
    }

    public long overlapSize() {
        return this.overlapSize;
    }

    public NewChunkListener getNewChunkListener() {
        return this.newChunkListener;
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.newChunkListener = listener;
    }

    public long actualSize() {
        try {
            return this.fileChannel.size();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }
}

