/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public enum Compressions implements Compression
{
    Binary{

        @Override
        public byte[] compress(byte[] bytes) throws IORuntimeException {
            return bytes;
        }

        @Override
        public byte[] uncompress(byte[] bytes) throws IORuntimeException {
            return bytes;
        }

        @Override
        public void compress(Bytes from, Bytes to) throws IORuntimeException {
            long copied = from.copyTo(to);
            to.writeSkip(copied);
        }

        @Override
        public void uncompress(Bytes from, Bytes to) {
            from.copyTo(to);
        }

        @Override
        public InputStream decompressingStream(InputStream input) {
            return input;
        }

        @Override
        public OutputStream compressingStream(OutputStream output) {
            return output;
        }
    }
    ,
    LZW{

        @Override
        public InputStream decompressingStream(InputStream input) {
            return new InflaterInputStream(input);
        }

        @Override
        public OutputStream compressingStream(OutputStream output) {
            return new DeflaterOutputStream(output, new Deflater(-1));
        }
    }
    ,
    GZIP{

        @Override
        public InputStream decompressingStream(InputStream input) {
            try {
                return new GZIPInputStream(input);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        public OutputStream compressingStream(OutputStream output) {
            try {
                return new GZIPOutputStream(output);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
    }
    ,
    Snappy{

        @Override
        public byte[] compress(byte[] bytes) throws IORuntimeException {
            try {
                return org.xerial.snappy.Snappy.compress((byte[])bytes);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        public byte[] uncompress(byte[] bytes) throws IORuntimeException {
            try {
                return org.xerial.snappy.Snappy.uncompress((byte[])bytes);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        public InputStream decompressingStream(InputStream input) {
            try {
                return new SnappyInputStream(input);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        public OutputStream compressingStream(OutputStream output) {
            return new SnappyOutputStream(output);
        }
    };

}

