/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingInputStream;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.core.util.ThrowingConsumerNonCapturing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StreamingDataInput<S extends StreamingDataInput<S>>
extends StreamingCommon<S> {
    @NotNull
    public S readPosition(long var1) throws BufferUnderflowException;

    @NotNull
    default public S readPositionUnlimited(long position) throws BufferUnderflowException {
        return this.readLimit(this.capacity()).readPosition(position);
    }

    @NotNull
    default public S readPositionRemaining(long position, long remaining) throws BufferUnderflowException {
        this.readLimit(position + remaining);
        return this.readPosition(position);
    }

    @NotNull
    public S readLimit(long var1) throws BufferUnderflowException;

    @NotNull
    public S readSkip(long var1) throws BufferUnderflowException;

    public void uncheckedReadSkipOne();

    public void uncheckedReadSkipBackOne();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength0(long length, @NotNull ThrowingConsumerNonCapturing<S, IORuntimeException, BytesOut> bytesConsumer, StringBuilder sb, BytesOut toBytes) throws BufferUnderflowException, IORuntimeException {
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            bytesConsumer.accept((Object)this, (CharSequence)sb, (Object)toBytes);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength(long length, @NotNull ThrowingConsumer<S, IORuntimeException> bytesConsumer) throws BufferUnderflowException, IORuntimeException {
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            bytesConsumer.accept((Object)this);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    @NotNull
    default public InputStream inputStream() {
        return new StreamingInputStream(this);
    }

    default public long readStopBit() throws IORuntimeException {
        return BytesInternal.readStopBit(this);
    }

    default public double readStopBitDouble() {
        return BytesInternal.readStopBitDouble(this);
    }

    default public double readStopBitDecimal() throws BufferOverflowException {
        long value = this.readStopBit();
        int scale = (int)(Math.abs(value) % 10L);
        return (double)(value /= 10L) / (double)Maths.tens((int)scale);
    }

    default public boolean readBoolean() {
        byte b = this.readByte();
        return BytesUtil.byteToBoolean(b);
    }

    public byte readByte();

    public int readUnsignedByte();

    public int uncheckedReadUnsignedByte();

    public short readShort() throws BufferUnderflowException;

    default public int readUnsignedShort() throws BufferUnderflowException {
        return this.readShort() & 0xFFFF;
    }

    default public int readUnsignedInt24() throws BufferUnderflowException {
        return this.readUnsignedShort() | this.readUnsignedByte() << 16;
    }

    public int readInt() throws BufferUnderflowException;

    default public long readUnsignedInt() throws BufferUnderflowException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() throws BufferUnderflowException;

    public float readFloat() throws BufferUnderflowException;

    public double readDouble() throws BufferUnderflowException;

    @Nullable
    default public String readUtf8() throws BufferUnderflowException, IORuntimeException, IllegalArgumentException {
        return BytesInternal.readUtf8(this);
    }

    @Deprecated
    @Nullable
    default public String readUTF\u0394() throws IORuntimeException, BufferUnderflowException, IllegalArgumentException {
        return BytesInternal.readUtf8(this);
    }

    @Nullable
    default public String read8bit() throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.read8bit(this);
    }

    default public <ACS extends Appendable & CharSequence> boolean readUtf8(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        AppendableUtil.setLength(sb, 0);
        if (this.readRemaining() <= 0L) {
            return false;
        }
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        BytesInternal.parseUtf8(this, sb, len);
        return true;
    }

    @Deprecated
    default public <ACS extends Appendable & CharSequence> boolean readUTF\u0394(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        return this.readUtf8(sb);
    }

    default public boolean read8bit(@NotNull Bytes b) throws BufferUnderflowException, IllegalStateException, BufferOverflowException {
        b.clear();
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        b.write((BytesStore)((Object)this), this.readPosition(), len);
        this.readSkip(len);
        return true;
    }

    default public <ACS extends Appendable & CharSequence> boolean read8bit(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        AppendableUtil.setLength(sb, 0);
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        try {
            AppendableUtil.parse8bit(this, sb, len);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return true;
    }

    default public boolean read8bit(@NotNull StringBuilder sb) throws IORuntimeException, BufferUnderflowException {
        sb.setLength(0);
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        try {
            AppendableUtil.parse8bit(this, sb, len);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return true;
    }

    default public int read(@NotNull byte[] bytes) {
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte();
        }
        return len;
    }

    default public int read(@NotNull byte[] bytes, int off, int len) {
        int len2 = (int)Math.min((long)len, this.readRemaining());
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = this.readByte();
        }
        return len2;
    }

    default public int read(@NotNull char[] bytes, int off, int len) {
        long remaining = this.readRemaining();
        if (remaining <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min((long)len, remaining);
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = (char)this.readUnsignedByte();
        }
        return len2;
    }

    default public void read(@NotNull ByteBuffer buffer) {
        for (int i = (int)Math.min(this.readRemaining(), (long)buffer.remaining()); i > 0; --i) {
            buffer.put(this.readByte());
        }
    }

    default public void read(@NotNull Bytes bytes, int length) {
        int len2 = (int)Math.min((long)length, this.readRemaining());
        for (int i = 0; i < len2; ++i) {
            bytes.writeByte(this.readByte());
        }
    }

    public int readVolatileInt() throws BufferUnderflowException;

    public long readVolatileLong() throws BufferUnderflowException;

    public int peekUnsignedByte();

    public void nativeRead(long var1, long var3) throws BufferUnderflowException;

    @NotNull
    default public <E extends Enum<E>> E readEnum(@NotNull Class<E> eClass) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.readEnum(this, eClass);
    }

    @Deprecated
    default public void parseUTF(Appendable sb, int length) throws IllegalArgumentException, BufferUnderflowException, UTFDataFormatRuntimeException {
        this.parseUtf8(sb, length);
    }

    default public void parseUtf8(Appendable sb, int length) throws IllegalArgumentException, BufferUnderflowException, UTFDataFormatRuntimeException {
        AppendableUtil.setLength(sb, 0);
        BytesInternal.parseUtf8(this, sb, length);
    }

    default public long parseHexLong() {
        return BytesInternal.parseHexLong(this);
    }

    public void copyTo(OutputStream var1) throws IOException;

    public long copyTo(BytesStore var1);

    default public void readHistogram(@NotNull Histogram histogram) {
        BytesInternal.readHistogram(this, histogram);
    }

    default public void readWithLength(Bytes bytes) {
        int i;
        bytes.clear();
        int length = Maths.toUInt31((long)this.readStopBit());
        for (i = 0; i < length - 7; ++i) {
            bytes.writeLong(this.readLong());
        }
        while (i < length) {
            bytes.writeByte(this.readByte());
            ++i;
        }
    }
}

