/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.Reader;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.IORuntimeException;

public class ByteStringReader
extends Reader {
    private final ByteStringParser in;

    public ByteStringReader(ByteStringParser in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.in.readRemaining() > 0L ? this.in.readUnsignedByte() : -1;
        }
        catch (IORuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long len = Math.min(this.in.readRemaining(), n);
        try {
            this.in.readSkip(len);
        }
        catch (BufferUnderflowException | IORuntimeException e) {
            throw new IOException(e);
        }
        return len;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            return this.in.read(cbuf, off, len);
        }
        catch (IORuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

