/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedNativeBytes<Underlying>
implements Bytes<Underlying> {
    protected final long capacity;
    @Nullable
    protected NativeBytesStore<Underlying> bytesStore;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    protected long readPosition;
    protected long writePosition;
    protected long writeLimit;

    public UncheckedNativeBytes(@NotNull Bytes<Underlying> underlyingBytes) throws IllegalStateException {
        underlyingBytes.reserve();
        this.bytesStore = (NativeBytesStore)underlyingBytes.bytesStore();
        assert (this.bytesStore.start() == 0L);
        this.writePosition = underlyingBytes.writePosition();
        this.writeLimit = underlyingBytes.writeLimit();
        this.readPosition = underlyingBytes.readPosition();
        this.capacity = this.bytesStore.capacity();
    }

    @Override
    @NotNull
    public Bytes<Underlying> unchecked(boolean unchecked) {
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readPosition(long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readLimit(long limit) {
        this.writePosition = limit;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writePosition(long position) {
        this.writePosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSkip(long bytesToSkip) {
        this.writePosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLimit(long limit) {
        this.writeLimit = limit;
        return this;
    }

    @Override
    @NotNull
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    protected long readOffsetPositionMoved(long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    protected long writeOffsetPositionMoved(long adding) {
        long oldPosition = this.writePosition;
        this.writePosition += adding;
        return oldPosition;
    }

    protected long prewriteOffsetPositionMoved(long substracting) {
        return this.readPosition -= substracting;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes, long offset, long length) throws IORuntimeException, BufferUnderflowException, BufferOverflowException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.bytesStore() instanceof NativeBytesStore && length >= 16L) {
            this.rawCopy(bytes, offset, length);
        } else {
            BytesInternal.write(bytes, offset, length, this);
        }
        return this;
    }

    public void rawCopy(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
            this.writeSkip(len);
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> clear() {
        this.readPosition = this.writePosition = this.start();
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    public Bytes<Underlying> clearAndPad(long length) throws BufferOverflowException {
        if (this.start() + length > this.capacity()) {
            throw new BufferOverflowException();
        }
        this.readPosition = this.writePosition = this.start() + length;
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @ForceInline
    public long readLimit() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    @ForceInline
    public long realCapacity() {
        return this.capacity();
    }

    @Override
    @ForceInline
    public long capacity() {
        return this.capacity;
    }

    @Override
    @Nullable
    public Underlying underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    @ForceInline
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    @ForceInline
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    void performRelease() {
        this.bytesStore.release();
        this.bytesStore = null;
    }

    @Override
    public int readUnsignedByte() {
        long offset = this.readOffsetPositionMoved(1L);
        return this.bytesStore.memory.readByte(this.bytesStore.address + offset);
    }

    @Override
    @ForceInline
    public byte readByte() {
        long offset = this.readOffsetPositionMoved(1L);
        return this.bytesStore.memory.readByte(this.bytesStore.address + offset);
    }

    @Override
    @ForceInline
    public int peekUnsignedByte() {
        try {
            return this.readRemaining() > 0L ? this.bytesStore.readUnsignedByte(this.readPosition) : -1;
        }
        catch (BufferUnderflowException | IORuntimeException e) {
            return -1;
        }
    }

    @Override
    @ForceInline
    public short readShort() {
        long offset = this.readOffsetPositionMoved(2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readDouble(offset);
    }

    @Override
    @ForceInline
    public int readVolatileInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    @ForceInline
    public long readVolatileLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readVolatileLong(offset);
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeByte(long offset, byte i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeShort(long offset, short i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeInt(long offset, int i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedInt(long offset, int i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeLong(long offset, long i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long offset, long i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeFloat(long offset, float d) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeDouble(long offset, double d) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, RandomDataInput bytes, long offset, long length) throws IORuntimeException, BufferUnderflowException, BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @ForceInline
    void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
        assert (this.writeCheckOffset0(offset, adding));
    }

    private boolean writeCheckOffset0(long offset, long adding) throws BufferOverflowException {
        if (offset < this.start()) {
            throw new BufferOverflowException();
        }
        if (offset + adding > this.writeLimit()) {
            assert (offset + adding <= this.writeLimit()) : "cant add bytes past the limit : limit=" + this.writeLimit() + ",offset=" + offset + ",adding=" + adding;
            throw new BufferOverflowException();
        }
        return true;
    }

    @Override
    @ForceInline
    public byte readByte(long offset) {
        return this.bytesStore.readByte(offset);
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.bytesStore.memory.readByte(this.bytesStore.address + offset) & 0xFF;
    }

    @Override
    @ForceInline
    public short readShort(long offset) {
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt(long offset) {
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong(long offset) {
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat(long offset) {
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble(long offset) {
        return this.bytesStore.readDouble(offset);
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.memory.writeByte(this.bytesStore.address + offset, i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteByte(byte i8) {
        long offset = this.prewriteOffsetPositionMoved(1L);
        this.bytesStore.memory.writeByte(this.bytesStore.address + offset, i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeShort(short i16) {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteShort(short i16) {
        long offset = this.prewriteOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteInt(int i) {
        long offset = this.prewriteOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeLong(long i64) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteLong(long i64) {
        long offset = this.prewriteOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeFloat(float f) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeDouble(double d) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) {
        long offsetInRDO = this.writeOffsetPositionMoved(length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewrite(byte[] bytes) {
        long offsetInRDO = this.prewriteOffsetPositionMoved(bytes.length);
        this.bytesStore.write(offsetInRDO, bytes);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(@NotNull ByteBuffer buffer) {
        this.bytesStore.write(this.writePosition, buffer, buffer.position(), buffer.limit());
        this.writePosition += (long)buffer.remaining();
        assert (this.writePosition <= this.writeLimit());
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long i) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public long address(long offset) {
        return this.bytesStore.address(offset);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("todo");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bytes)) {
            return false;
        }
        Bytes b2 = (Bytes)obj;
        long remaining = this.readRemaining();
        return b2.readRemaining() == remaining && this.equalsBytes(b2, remaining);
    }

    public boolean equalsBytes(@NotNull Bytes b2, long remaining) {
        try {
            long i;
            for (i = 0L; i < remaining - 7L; ++i) {
                if (this.readLong(this.readPosition() + i) == b2.readLong(b2.readPosition() + i)) continue;
                return false;
            }
            while (i < remaining) {
                if (this.readByte(this.readPosition() + i) != b2.readByte(b2.readPosition() + i)) {
                    return false;
                }
                ++i;
            }
        }
        catch (BufferUnderflowException | IORuntimeException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return BytesInternal.toString(this);
    }

    @Override
    @ForceInline
    public void nativeRead(long address, long size) {
        this.bytesStore.nativeRead(this.readPosition(), address, size);
        this.readSkip(size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long size) {
        this.bytesStore.nativeWrite(address, this.writePosition(), size);
        this.writeSkip(size);
    }

    @Override
    @ForceInline
    public void nativeRead(long position, long address, long size) {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long position, long size) {
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this.bytesStore;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        if (this.readLimit() >= Integer.MAX_VALUE || this.start() != 0L) {
            throw new AssertionError();
        }
        int b = 0;
        NativeBytesStore bytesStore = (NativeBytesStore)this.bytesStore();
        Memory memory = bytesStore.memory;
        assert (memory != null);
        int lim = (int)this.readLimit();
        for (int i = (int)this.readPosition(); i < lim; ++i) {
            b = (byte)(b + memory.readByte(bytesStore.address + (long)i));
        }
        return b & 0xFF;
    }

    @Override
    @NotNull
    public Bytes<Underlying> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IORuntimeException {
        if (cs instanceof BytesStore) {
            return (Bytes)this.write((BytesStore)cs);
        }
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        long address = this.bytesStore.address(offset);
        Memory memory = this.bytesStore.memory;
        assert (memory != null);
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            memory.writeByte(address + (long)i, (byte)c);
        }
        return this;
    }
}

