/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeBytes<Underlying>
extends VanillaBytes<Underlying> {
    private static final Logger LOG = LoggerFactory.getLogger(NativeBytes.class);

    NativeBytes(@NotNull BytesStore store) throws IllegalStateException {
        super(store, 0L, Long.MAX_VALUE);
    }

    @NotNull
    public static NativeBytes<Void> nativeBytes() {
        try {
            return new NativeBytes<Void>(NoBytesStore.noBytesStore());
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static NativeBytes<Void> nativeBytes(long initialCapacity) throws IllegalArgumentException {
        NativeBytesStore<Void> store = NativeBytesStore.nativeStoreWithFixedCapacity(initialCapacity);
        try {
            NativeBytes<Void> nativeBytes = new NativeBytes<Void>(store);
            return nativeBytes;
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            store.release();
        }
    }

    public static BytesStore<Bytes<Void>, Void> copyOf(@NotNull Bytes bytes) {
        long remaining = bytes.readRemaining();
        try {
            NativeBytes<Void> bytes2 = Bytes.allocateElasticDirect(remaining);
            bytes2.write(bytes, 0L, remaining);
            return bytes2;
        }
        catch (IllegalArgumentException | BufferOverflowException | BufferUnderflowException | IORuntimeException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        if (!this.bytesStore.inside(offset + adding - 1L)) {
            this.checkResize(offset + adding);
        }
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException, IORuntimeException {
        try {
            this.writeCheckOffset(size, 1L);
        }
        catch (BufferOverflowException e) {
            throw new IllegalArgumentException("Bytes cannot be resized to " + size + " limit: " + this.capacity());
        }
    }

    private void checkResize(long endOfBuffer) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    private void resize(long endOfBuffer) throws IllegalArgumentException, BufferOverflowException, IORuntimeException {
        if (endOfBuffer < 0L) {
            throw new IllegalArgumentException(endOfBuffer + " < 0");
        }
        long ps = OS.pageSize();
        long size = Math.max(endOfBuffer, this.bytesStore.capacity() * 3L / 2L) + ps & (ps - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytesStore<Object> store = this.bytesStore.underlyingObject() instanceof ByteBuffer ? NativeBytesStore.elasticByteBuffer(Maths.toInt32((long)size)) : NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
        try {
            this.bytesStore.copyTo(store);
            this.bytesStore.release();
        }
        catch (IllegalStateException e) {
            LOG.error("", (Throwable)e);
        }
        this.bytesStore = store;
    }

    @Override
    public long readIncompleteLong(long offset) throws IORuntimeException {
        return this.bytesStore.readIncompleteLong(offset);
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        long position = this.writePosition();
        this.ensureCapacity(position + (long)length);
        super.write(bytes, offset, length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException, BufferUnderflowException, IORuntimeException {
        long position = this.writePosition();
        this.ensureCapacity(position + length);
        super.write(bytes, offset, length);
        return this;
    }
}

