/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.Writer;
import java.nio.BufferOverflowException;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.IORuntimeException;

public class ByteStringWriter
extends Writer {
    private final ByteStringAppender out;

    public ByteStringWriter(ByteStringAppender out) {
        this.out = out;
    }

    @Override
    public void write(int c) throws IOException {
        try {
            this.out.append(c);
        }
        catch (IllegalArgumentException | BufferOverflowException | IORuntimeException e) {
            throw new IOException((Throwable)e);
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.out.append(str);
    }

    @Override
    public void write(String str, int off, int len) throws IndexOutOfBoundsException, IOException {
        this.out.append(str, off, off + len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IndexOutOfBoundsException, IOException {
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.out.append(cbuf[i + off]);
        }
    }
}

