/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

public interface RandomDataInput
extends RandomCommon {
    public static final String[] charToString = RandomDataInput.createCharToString();

    @NotNull
    public static String[] createCharToString() {
        int i;
        String[] charToString = new String[256];
        charToString[0] = "\u0660";
        for (i = 1; i < 21; ++i) {
            charToString[i] = Character.toString((char)(i + 9351));
        }
        for (i = 32; i < 256; ++i) {
            charToString[i] = Character.toString((char)i);
        }
        for (i = 21; i < 32; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        for (i = 128; i < 160; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        return charToString;
    }

    @ForceInline
    default public boolean readBoolean(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.readByte(offset) != 0;
    }

    public byte readByte(long var1) throws BufferUnderflowException, IORuntimeException;

    @ForceInline
    default public int readUnsignedByte(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.readByte(offset) & 0xFF;
    }

    public short readShort(long var1) throws BufferUnderflowException, IORuntimeException;

    @ForceInline
    default public int readUnsignedShort(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.readShort(offset) & 0xFFFF;
    }

    public int readInt(long var1) throws BufferUnderflowException, IORuntimeException;

    @ForceInline
    default public long readUnsignedInt(long offset) throws BufferUnderflowException, IORuntimeException {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public long readLong(long var1) throws BufferUnderflowException, IORuntimeException;

    public float readFloat(long var1) throws BufferUnderflowException, IORuntimeException;

    public double readDouble(long var1) throws BufferUnderflowException, IORuntimeException;

    default public String printable(long offset) throws BufferUnderflowException, IORuntimeException {
        return charToString[this.readUnsignedByte(offset)];
    }

    default public int readVolatileInt(long offset) throws BufferUnderflowException, IORuntimeException {
        OS.memory().loadFence();
        return this.readInt(offset);
    }

    default public float readVolatileFloat(long offset) throws BufferUnderflowException, IORuntimeException {
        return Float.intBitsToFloat(this.readVolatileInt(offset));
    }

    default public long readVolatileLong(long offset) throws BufferUnderflowException, IORuntimeException {
        OS.memory().loadFence();
        return this.readLong(offset);
    }

    default public double readVolatileDouble(long offset) throws BufferUnderflowException, IORuntimeException {
        return Double.longBitsToDouble(this.readVolatileLong(offset));
    }

    default public long parseLong(long offset) throws BufferUnderflowException, IORuntimeException {
        return BytesInternal.parseLong(this, offset);
    }

    public void nativeRead(long var1, long var3, long var5);

    default public int copyTo(@NotNull byte[] bytes) throws BufferUnderflowException, IORuntimeException {
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte(this.start() + (long)i);
        }
        return len;
    }

    default public long readIncompleteLong(long offset) throws IORuntimeException {
        long left = this.readRemaining() - offset;
        long l = 0L;
        try {
            if (left >= 8L) {
                return this.readLong(offset);
            }
            if (left == 4L) {
                return this.readInt(offset);
            }
            l = 0L;
            int remaining = (int)left;
            for (int i = 0; i < remaining; ++i) {
                l |= (long)this.readUnsignedByte(offset + (long)i) << i * 8;
            }
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        return l;
    }

    public long realCapacity();

    default public int addAndGetInt(long offset, int adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetInt(this, offset, adding);
    }

    default public long addAndGetLong(long offset, long adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetLong(this, offset, adding);
    }

    default public float addAndGetFloat(long offset, float adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetFloat(this, offset, adding);
    }

    default public double addAndGetDouble(long offset, double adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetDouble(this, offset, adding);
    }
}

