/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.annotation.NotNull;

public class AppendableUtil {
    public static void setCharAt(@NotNull Appendable sb, int index, char ch) throws IllegalArgumentException, BufferOverflowException, IORuntimeException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setCharAt(index, ch);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).writeByte(index, ch);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    @ForceInline
    public static void setLength(@NotNull Appendable sb, int newLength) throws BufferUnderflowException, IllegalArgumentException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setLength(newLength);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).readPosition(newLength);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, double value) throws IllegalArgumentException, IORuntimeException, BufferOverflowException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, long value) throws IllegalArgumentException, IORuntimeException, BufferOverflowException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(@NotNull ACS sb, String str) {
        try {
            sb.append(str);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharsTester tester) throws IORuntimeException {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte(), bytes.peekUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    public static void readUTFAndAppend(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharsTester tester) throws IOException, BufferUnderflowException {
        try {
            int c;
            block15: {
                do {
                    if ((c = bytes.readUnsignedByte()) >= 128) break block15;
                    if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append((char)c);
                } while (bytes.readRemaining() != 0L);
                return;
            }
            bytes.readSkip(-1L);
            block8: while (true) {
                c = bytes.readUnsignedByte();
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                            return;
                        }
                        appendable.append((char)c);
                        continue block8;
                    }
                    case 12: 
                    case 13: {
                        int char2 = bytes.readUnsignedByte();
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte");
                        }
                        char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        if (tester.isStopChar(c2, bytes.peekUnsignedByte())) {
                            return;
                        }
                        appendable.append(c2);
                        continue block8;
                    }
                    case 14: {
                        int char2 = bytes.readUnsignedByte();
                        int char3 = bytes.readUnsignedByte();
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte ");
                        }
                        char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                        if (tester.isStopChar(c3, bytes.peekUnsignedByte())) {
                            return;
                        }
                        appendable.append(c3);
                        continue block8;
                    }
                }
                break;
            }
            throw new UTFDataFormatException("malformed input around byte ");
        }
        catch (IORuntimeException e) {
            throw new IOException(e);
        }
    }

    public static void parse8bit_SB1(@NotNull Bytes bytes, @NotNull StringBuilder sb, int utflen) throws IORuntimeException, BufferUnderflowException {
        if ((long)utflen > bytes.readRemaining()) {
            throw new BufferUnderflowException();
        }
        NativeBytesStore nbs = (NativeBytesStore)bytes.bytesStore();
        long offset = bytes.readPosition();
        int count = BytesInternal.parse8bit_SB1(offset, nbs, sb, utflen);
        bytes.readSkip(count);
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, Appendable appendable, int utflen) throws IORuntimeException, BufferUnderflowException {
        if (bytes instanceof Bytes && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            AppendableUtil.parse8bit_SB1((Bytes)bytes, (StringBuilder)appendable, utflen);
        } else {
            BytesInternal.parse8bit1(bytes, appendable, utflen);
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(ACS a, CharSequence cs, long start, long len) {
        if (a instanceof StringBuilder) {
            if (cs instanceof Bytes) {
                ((StringBuilder)a).append(Bytes.toString((Bytes)cs, start, len));
            } else {
                ((StringBuilder)a).append(cs.subSequence(Maths.toInt32((long)start), Maths.toInt32((long)len)));
            }
        } else if (a instanceof Bytes) {
            ((Bytes)a).appendUtf8(cs, Maths.toInt32((long)start), Maths.toInt32((long)len));
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

