/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.SubZeroedBytes;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.annotation.ForceInline;

public class ZeroedBytes<Underlying>
extends VanillaBytes<Underlying> {
    private final UnderflowMode underflowMode;

    public ZeroedBytes(BytesStore store, UnderflowMode underflowMode, long writeLimit) {
        super(store, store.writePosition(), writeLimit);
        this.underflowMode = underflowMode;
    }

    @Override
    public Bytes<Underlying> bytesForRead() {
        return this.isClear() ? new ZeroedBytes<Underlying>(this.bytesStore, this.underflowMode, this.writeLimit()) : new SubZeroedBytes(this.bytesStore, this.underflowMode, this.readPosition(), this.readLimit());
    }

    @Override
    @ForceInline
    public byte readByte() {
        return this.positionOk(1) ? super.readByte() : (byte)0;
    }

    @ForceInline
    private boolean positionOk(int needs) {
        return this.underflowMode.isRemainingOk(this.readRemaining(), needs);
    }

    @Override
    @ForceInline
    public short readShort() {
        return this.positionOk(2) ? super.readShort() : (short)0;
    }

    @Override
    @ForceInline
    public int readInt() {
        return this.positionOk(4) ? super.readInt() : 0;
    }

    @Override
    @ForceInline
    public long readLong() {
        return this.positionOk(8) ? super.readLong() : 0L;
    }

    @Override
    @ForceInline
    public float readFloat() {
        return this.positionOk(4) ? super.readFloat() : 0.0f;
    }

    @Override
    @ForceInline
    public double readDouble() {
        return this.positionOk(8) ? super.readDouble() : 0.0;
    }
}

