/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounter;
import org.jetbrains.annotations.Nullable;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class NativeBytesStore<Underlying>
implements BytesStore<NativeBytesStore<Underlying>, Underlying> {
    private static final long MEMORY_MAPPED_SIZE = 131072L;
    private static final Memory MEMORY = OS.memory();
    @Nullable
    private final Cleaner cleaner;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private final boolean elastic;
    private final Underlying underlyingObject;
    protected long address;
    long maximumLimit;

    private NativeBytesStore(ByteBuffer bb, boolean elastic) {
        this.elastic = elastic;
        this.underlyingObject = bb;
        this.address = ((DirectBuffer)((Object)bb)).address();
        this.maximumLimit = bb.capacity();
        this.cleaner = ((DirectBuffer)((Object)bb)).cleaner();
    }

    public NativeBytesStore(long address, long maximumLimit, Runnable deallocator, boolean elastic) {
        this.address = address;
        this.maximumLimit = maximumLimit;
        this.cleaner = deallocator == null ? null : Cleaner.create((Object)this, (Runnable)deallocator);
        this.underlyingObject = null;
        this.elastic = elastic;
    }

    public static NativeBytesStore<ByteBuffer> wrap(ByteBuffer bb) {
        return new NativeBytesStore<ByteBuffer>(bb, false);
    }

    public static NativeBytesStore<Void> nativeStore(long capacity) {
        return NativeBytesStore.of(capacity, true, true);
    }

    private static NativeBytesStore<Void> of(long capacity, boolean zeroOut, boolean elastic) {
        long address = MEMORY.allocate(capacity);
        if (zeroOut || capacity < 131072L) {
            MEMORY.setMemory(address, capacity, (byte)0);
            MEMORY.storeFence();
        }
        Deallocator deallocator = new Deallocator(address);
        return new NativeBytesStore<Void>(address, capacity, deallocator, elastic);
    }

    public static NativeBytesStore<Void> nativeStoreWithFixedCapacity(long capacity) {
        return NativeBytesStore.of(capacity, true, false);
    }

    public static NativeBytesStore<Void> lazyNativeBytesStoreWithFixedCapacity(long capacity) {
        return NativeBytesStore.of(capacity, false, false);
    }

    public static NativeBytesStore<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer(OS.pageSize());
    }

    public static NativeBytesStore<ByteBuffer> elasticByteBuffer(int size) {
        return new NativeBytesStore<ByteBuffer>(ByteBuffer.allocateDirect(size), true);
    }

    @Override
    public BytesStore<NativeBytesStore<Underlying>, Underlying> copy() {
        if (this.underlyingObject == null) {
            NativeBytesStore<Void> copy = NativeBytesStore.of(this.realCapacity(), false, true);
            OS.memory().copyMemory(this.address, copy.address, this.capacity());
            return copy;
        }
        if (this.underlyingObject instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.capacity()));
            bb.put((ByteBuffer)this.underlyingObject);
            bb.clear();
            return NativeBytesStore.wrap(bb);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes<Underlying> bytesForWrite() {
        return this.elastic ? new NativeBytes(this) : new VanillaBytes(this);
    }

    @Override
    public long realCapacity() {
        return this.maximumLimit;
    }

    @Override
    public long capacity() {
        return this.maximumLimit;
    }

    @Override
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    public NativeBytesStore<Underlying> zeroOut(long start, long end) {
        if (start < this.writePosition() || end > this.writeLimit()) {
            throw new IllegalArgumentException("position: " + this.writePosition() + ", start: " + start + ", end: " + end + ", limit: " + this.writeLimit());
        }
        if (start >= end) {
            return this;
        }
        MEMORY.setMemory(this.address + this.translate(start), end - start, (byte)0);
        return this;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        return MEMORY.compareAndSwapInt(this.address + this.translate(offset), expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        return MEMORY.compareAndSwapLong(this.address + this.translate(offset), expected, value);
    }

    private long translate(long offset) {
        long offset2 = offset - this.start();
        if (offset2 < 0L || offset2 > this.capacity()) {
            throw new IllegalArgumentException("Offset out of bounds " + offset2 + " cap: " + this.capacity());
        }
        return offset2;
    }

    public void reserve() {
        this.refCount.reserve();
    }

    public void release() {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public byte readByte(long offset) {
        return MEMORY.readByte(this.address + this.translate(offset));
    }

    @Override
    public short readShort(long offset) {
        return MEMORY.readShort(this.address + this.translate(offset));
    }

    @Override
    public int readInt(long offset) {
        return MEMORY.readInt(this.address + this.translate(offset));
    }

    @Override
    public long readLong(long offset) {
        return MEMORY.readLong(this.address + this.translate(offset));
    }

    @Override
    public float readFloat(long offset) {
        return MEMORY.readFloat(this.address + this.translate(offset));
    }

    @Override
    public double readDouble(long offset) {
        return MEMORY.readDouble(this.address + this.translate(offset));
    }

    @Override
    public int readVolatileInt(long offset) {
        return MEMORY.readVolatileInt(this.address + this.translate(offset));
    }

    @Override
    public long readVolatileLong(long offset) {
        return MEMORY.readVolatileLong(this.address + this.translate(offset));
    }

    @Override
    public NativeBytesStore<Underlying> writeByte(long offset, byte i8) {
        MEMORY.writeByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeShort(long offset, short i16) {
        MEMORY.writeShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeInt(long offset, int i32) {
        MEMORY.writeInt(this.address + this.translate(offset), i32);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeOrderedInt(long offset, int i) {
        MEMORY.writeOrderedInt(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeLong(long offset, long i64) {
        MEMORY.writeLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeOrderedLong(long offset, long i) {
        MEMORY.writeOrderedLong(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeFloat(long offset, float f) {
        MEMORY.writeFloat(this.address + this.translate(offset), f);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> writeDouble(long offset, double d) {
        MEMORY.writeDouble(this.address + this.translate(offset), d);
        return this;
    }

    @Override
    public NativeBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        MEMORY.copyMemory(bytes, offset, this.address + this.translate(offsetInRDO), length);
        return this;
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) {
        if (bytes.isDirect()) {
            MEMORY.copyMemory(((DirectBuffer)((Object)bytes)).address(), this.address + this.translate(offsetInRDO), (long)length);
        } else {
            MEMORY.copyMemory(bytes.array(), offset, this.address + this.translate(offsetInRDO), length);
        }
    }

    @Override
    public NativeBytesStore<Underlying> write(long offsetInRDO, RandomDataInput bytes, long offset, long length) {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            this.writeLong(offsetInRDO + i, bytes.readLong(offset + i));
        }
        while (i < length) {
            this.writeByte(offsetInRDO + i, bytes.readByte(offset + i));
            ++i;
        }
        return this;
    }

    @Override
    public long address() {
        return this.address;
    }

    private void performRelease() {
        if (this.cleaner != null) {
            this.cleaner.clean();
        }
    }

    @Override
    public String toString() {
        return BytesUtil.toString(this);
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        OS.memory().copyMemory(this.address() + position, address, size);
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        OS.memory().copyMemory(address, this.address() + position, size);
    }

    void write8bit(long position, char[] chars, int offset, int length) {
        long addr = this.address + this.translate(position);
        Memory memory = MEMORY;
        for (int i = 0; i < length; ++i) {
            memory.writeByte(addr + (long)i, (byte)chars[offset + i]);
        }
    }

    void read8bit(long position, char[] chars, int length) {
        long addr = this.address + this.translate(position);
        Memory memory = MEMORY;
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(memory.readByte(addr + (long)i) & 0xFF);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof BytesStore && BytesUtil.contentEqual(this, (BytesStore)obj);
    }

    static class Deallocator
    implements Runnable {
        private volatile long address;

        Deallocator(long address) {
            assert (address != 0L);
            this.address = address;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            this.address = 0L;
            MEMORY.freeMemory(this.address);
        }
    }
}

