/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ExpectedBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import org.jetbrains.annotations.NotNull;

public interface Bytes<Underlying>
extends BytesStore<Bytes<Underlying>, Underlying>,
StreamingDataInput<Bytes<Underlying>>,
StreamingDataOutput<Bytes<Underlying>>,
ByteStringParser<Bytes<Underlying>>,
ByteStringAppender<Bytes<Underlying>> {
    public static final long MAX_CAPACITY = Long.MAX_VALUE;

    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer().bytesForWrite();
    }

    public static Bytes<ByteBuffer> wrapForRead(ByteBuffer byteBuffer) {
        return BytesStore.wrap(byteBuffer).bytesForRead(UnderflowMode.BOUNDED);
    }

    public static Bytes<ByteBuffer> wrapForWrite(ByteBuffer byteBuffer) {
        return BytesStore.wrap(byteBuffer).bytesForWrite();
    }

    public static Bytes<byte[]> expect(String text) {
        return Bytes.expect(Bytes.wrap(text.getBytes(StandardCharsets.ISO_8859_1)));
    }

    public static <B extends BytesStore<B, Underlying>, Underlying> Bytes<Underlying> expect(BytesStore<B, Underlying> bytesStore) {
        return new VanillaBytes(new ExpectedBytesStore<B, Underlying>(bytesStore));
    }

    public static Bytes<byte[]> wrap(byte[] byteArray) {
        return BytesStore.wrap(byteArray).bytesForRead();
    }

    public static Bytes<byte[]> from(String text) {
        return Bytes.wrap(text.getBytes(StandardCharsets.UTF_8));
    }

    public static String toString(@NotNull Bytes<?> buffer) {
        if (buffer.readRemaining() == 0L) {
            return "";
        }
        return (String)buffer.parseWithLength(buffer.readRemaining(), b -> {
            StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            return builder.toString();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(@NotNull Bytes buffer, long position, long len) {
        long pos = buffer.readPosition();
        long limit = buffer.readLimit();
        buffer.readPosition(position);
        buffer.readLimit(position + len);
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.readLimit(limit);
            buffer.readPosition(pos);
        }
    }

    @Override
    default public boolean isClear() {
        return this.start() == this.readPosition() && this.writeLimit() == this.capacity();
    }

    @Override
    default public long realCapacity() {
        return BytesStore.super.realCapacity();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy();

    default public String toHexString() {
        return BytesUtil.toHexString(this, this.readPosition(), this.readRemaining());
    }

    default public String toHexString(long maxLength) {
        if (this.readRemaining() < maxLength) {
            return this.toHexString();
        }
        return BytesUtil.toHexString(this, this.readPosition(), maxLength) + ".... truncated";
    }

    public boolean isElastic();

    default public void ensureCapacity(long size) {
        if (size > this.capacity()) {
            throw new UnsupportedOperationException(this.isElastic() ? "todo" : "not elastic");
        }
    }

    @Override
    default public Bytes<Underlying> bytesForRead() {
        return this.isClear() ? BytesStore.super.bytesForRead() : new SubBytes((BytesStore)this, this.readPosition(), this.readLimit() + this.start());
    }
}

