/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.bytes.algo.VanillaBytesStoreHash;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;

public enum OptimisedBytesHash implements BytesStoreHash<Bytes>
{
    INSTANCE;

    public static final Memory MEMORY;
    private static final int TOP_BYTES;

    static long applyAsLong1to7(@NotNull Bytes store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = (long)remaining * 1829709757L;
        long l0 = OptimisedBytesHash.readIncompleteLong(address, remaining);
        long l0a = l0 >> 32;
        boolean l1a = false;
        long l2 = 0L;
        boolean l2a = false;
        long l3 = 0L;
        boolean l3a = false;
        long h1 = 0L;
        long h2 = (0L - l0a) * 2053402137L;
        long h3 = (0L + l0a - 0L) * -2057448229L;
        return VanillaBytesStoreHash.agitate(h0 += (l0 + 0L - 0L) * 1539836845L) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    static long applyAsLong8(@NotNull Bytes store) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long remaining = 8L;
        long h0 = 14637678056L;
        long l0 = MEMORY.readLong(address);
        long l0a = MEMORY.readInt(address + (long)TOP_BYTES);
        boolean l1a = false;
        long l2 = 0L;
        boolean l2a = false;
        long l3 = 0L;
        boolean l3a = false;
        long h1 = 0L;
        long h2 = (0L - l0a) * 2053402137L;
        long h3 = (0L + l0a - 0L) * -2057448229L;
        return VanillaBytesStoreHash.agitate(h0 += (l0 + 0L - 0L) * 1539836845L) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    public static long hash(long l) {
        long remaining = 8L;
        long h0 = 14637678056L;
        long l0 = l;
        int l0a = (int)(l0 >> 32);
        boolean l1a = false;
        long l2 = 0L;
        boolean l2a = false;
        long l3 = 0L;
        boolean l3a = false;
        long h1 = 0L;
        long h2 = (0L - (long)l0a) * 2053402137L;
        long h3 = (0L + (long)l0a - 0L) * -2057448229L;
        return VanillaBytesStoreHash.agitate(h0 += (l0 + 0L - 0L) * 1539836845L) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    static long applyAsLong9to16(@NotNull Bytes store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = (long)remaining * 1829709757L;
        int left = remaining;
        long addrI = address;
        long l0 = OptimisedBytesHash.readIncompleteLong(addrI, left);
        int l0a = (int)(l0 >> 32);
        long l1 = OptimisedBytesHash.readIncompleteLong(addrI + 8L, left - 8);
        int l1a = (int)(l1 >> 32);
        long l2 = 0L;
        boolean l2a = false;
        long l3 = 0L;
        boolean l3a = false;
        long h1 = (l1 + 0L - 0L) * -361396777L;
        long h2 = (0L - (long)l0a) * 2053402137L;
        long h3 = (0L + (long)l0a - (long)l1a) * -2057448229L;
        return VanillaBytesStoreHash.agitate(h0 += (l0 + (long)l1a - 0L) * 1539836845L) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    static long applyAsLong17to32(@NotNull Bytes store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = (long)remaining * 1829709757L;
        int left = remaining;
        long addrI = address;
        long l0 = MEMORY.readLong(addrI);
        int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
        long l1 = MEMORY.readLong(addrI + 8L);
        int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
        long l2 = OptimisedBytesHash.readIncompleteLong(addrI + 16L, left - 16);
        int l2a = (int)(l2 >> 32);
        long l3 = OptimisedBytesHash.readIncompleteLong(addrI + 24L, left - 24);
        int l3a = (int)(l3 >> 32);
        long h1 = (l1 + (long)l2a - (long)l3a) * -361396777L;
        long h2 = (l2 + (long)l3a - (long)l0a) * 2053402137L;
        long h3 = (l3 + (long)l0a - (long)l1a) * -2057448229L;
        return VanillaBytesStoreHash.agitate(h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    public static long applyAsLong32bytesMultiple(@NotNull Bytes store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = remaining * 1829709757;
        long h1 = 0L;
        long h2 = 0L;
        long h3 = 0L;
        for (int i = 0; i < remaining - 31; i += 32) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = address + (long)i;
            long l0 = MEMORY.readLong(addrI);
            int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
            long l1 = MEMORY.readLong(addrI + 8L);
            int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
            long l2 = MEMORY.readLong(addrI + 16L);
            int l2a = MEMORY.readInt(addrI + 16L + (long)TOP_BYTES);
            long l3 = MEMORY.readLong(addrI + 24L);
            int l3a = MEMORY.readInt(addrI + 24L + (long)TOP_BYTES);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
        }
        return VanillaBytesStoreHash.agitate(h0) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    public static long applyAsLongAny(@NotNull Bytes store, int remaining) {
        int i;
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = (long)remaining * 1829709757L;
        long h1 = 0L;
        long h2 = 0L;
        long h3 = 0L;
        for (i = 0; i < remaining - 31; i += 32) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = address + (long)i;
            long l0 = MEMORY.readLong(addrI);
            int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
            long l1 = MEMORY.readLong(addrI + 8L);
            int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
            long l2 = MEMORY.readLong(addrI + 16L);
            int l2a = MEMORY.readInt(addrI + 16L + (long)TOP_BYTES);
            long l3 = MEMORY.readLong(addrI + 24L);
            int l3a = MEMORY.readInt(addrI + 24L + (long)TOP_BYTES);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
        }
        int left = remaining - i;
        if (left > 0) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = address + (long)i;
            if (left <= 16) {
                long l0 = OptimisedBytesHash.readIncompleteLong(addrI, left);
                int l0a = (int)(l0 >> 32);
                long l1 = OptimisedBytesHash.readIncompleteLong(addrI + 8L, left - 8);
                int l1a = (int)(l1 >> 32);
                long l2 = 0L;
                boolean l2a = false;
                long l3 = 0L;
                boolean l3a = false;
                h0 += (l0 + (long)l1a - 0L) * 1539836845L;
                h1 += (l1 + 0L - 0L) * -361396777L;
                h2 += (0L - (long)l0a) * 2053402137L;
                h3 += (0L + (long)l0a - (long)l1a) * -2057448229L;
            } else {
                long l0 = MEMORY.readLong(addrI);
                int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
                long l1 = MEMORY.readLong(addrI + 8L);
                int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
                long l2 = OptimisedBytesHash.readIncompleteLong(addrI + 16L, left - 16);
                int l2a = (int)(l2 >> 32);
                long l3 = OptimisedBytesHash.readIncompleteLong(addrI + 24L, left - 24);
                int l3a = (int)(l3 >> 32);
                h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
                h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
                h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
                h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
            }
        }
        return VanillaBytesStoreHash.agitate(h0) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    static long readIncompleteLong(long address, int len) {
        if (len >= 8) {
            return MEMORY.readLong(address);
        }
        if (len == 4) {
            return MEMORY.readInt(address);
        }
        long l = 0L;
        for (int i = 0; i < len; ++i) {
            byte b = MEMORY.readByte(address + (long)i);
            l |= (long)(b & 0xFF) << i * 8;
        }
        return l;
    }

    @Override
    public long applyAsLong(@NotNull Bytes store) {
        int remaining = Maths.toInt32((long)store.readRemaining());
        if (remaining <= 16) {
            if (remaining == 0) {
                return 0L;
            }
            if (remaining < 8) {
                return OptimisedBytesHash.applyAsLong1to7(store, remaining);
            }
            if (remaining == 8) {
                return OptimisedBytesHash.applyAsLong8(store);
            }
            return OptimisedBytesHash.applyAsLong9to16(store, remaining);
        }
        if (remaining <= 32) {
            return OptimisedBytesHash.applyAsLong17to32(store, remaining);
        }
        if ((remaining & 0x1F) == 0) {
            return OptimisedBytesHash.applyAsLong32bytesMultiple(store, remaining);
        }
        return OptimisedBytesHash.applyAsLongAny(store, remaining);
    }

    static {
        MEMORY = OS.memory();
        TOP_BYTES = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 4 : 0;
    }
}

