/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.util.StringUtils;

public class UTF8StringInterner {
    private static final StringBuilderPool SBP = new StringBuilderPool();
    private final String[] interner;
    private final int mask;

    public UTF8StringInterner(int capacity) {
        int n = Maths.nextPower2((int)capacity, (int)128);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    public String intern(Bytes cs) {
        long hash = BytesStoreHash.hash(cs);
        int h = (int)(hash ^ hash >> 32) & this.mask;
        String s = this.interner[h];
        if (StringUtils.isEqual((CharSequence)s, (CharSequence)cs)) {
            return s;
        }
        StringBuilder sb = SBP.acquireStringBuilder();
        BytesUtil.parseUTF((StreamingDataInput)cs, (Appendable)sb, Maths.toInt32((long)cs.readRemaining()));
        this.interner[h] = sb.toString();
        return this.interner[h];
    }
}

