/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;

public enum OptimisedBytesHash implements BytesStoreHash<VanillaBytes>
{
    INSTANCE;

    private static final int TOP_BYTES;
    public static final Memory MEMORY;

    @Override
    public long applyAsLong(VanillaBytes store) {
        int remaining = Maths.toInt32((long)store.readRemaining());
        if (remaining <= 16) {
            if (remaining == 0) {
                return 0L;
            }
            if (remaining < 8) {
                return OptimisedBytesHash.applyAsLong1to7(store, remaining);
            }
            if (remaining == 8) {
                return OptimisedBytesHash.applyAsLong8(store);
            }
            return OptimisedBytesHash.applyAsLong9to16(store, remaining);
        }
        if (remaining <= 32) {
            return OptimisedBytesHash.applyAsLong17to32(store, remaining);
        }
        return OptimisedBytesHash.applyAsLongAny(store, remaining);
    }

    static long applyAsLong1to7(VanillaBytes store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long l0 = OptimisedBytesHash.readIncompleteLong(address, remaining);
        long l0a = l0 >> 32;
        long h0 = (long)remaining * -978308811L + l0 * 1228037679L;
        long h1 = l0a * 846538563L;
        return Maths.agitate((long)h0) ^ Maths.agitate((long)h1);
    }

    static long applyAsLong8(VanillaBytes store) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long l0 = MEMORY.readLong(address);
        long l0a = MEMORY.readInt(address + (long)TOP_BYTES);
        long h0 = -7826470488L + l0 * 1228037679L;
        long h1 = l0a * 846538563L;
        return Maths.agitate((long)h0) ^ Maths.agitate((long)h1);
    }

    public static long hash(long l) {
        long h0 = -7826470488L + l * 1228037679L;
        long h1 = (l >> 32) * 846538563L;
        return Maths.agitate((long)h0) ^ Maths.agitate((long)h1);
    }

    static long applyAsLong9to16(VanillaBytes store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = (long)remaining * -978308811L;
        long h1 = 0L;
        int left = remaining;
        long addrI = address;
        long l0 = OptimisedBytesHash.readIncompleteLong(addrI, left);
        int l0a = (int)(l0 >> 32);
        long l1 = OptimisedBytesHash.readIncompleteLong(addrI + 8L, left - 8);
        int l1a = (int)(l1 >> 32);
        return Maths.agitate((long)(h0 += (l0 + (long)l1a) * 1228037679L)) ^ Maths.agitate((long)(h1 += (l1 + (long)l0a) * 846538563L));
    }

    static long applyAsLong17to32(VanillaBytes store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = (long)remaining * -978308811L;
        long h1 = 0L;
        int left = remaining;
        long addrI = address;
        long l0 = OptimisedBytesHash.readIncompleteLong(addrI, left);
        int l0a = (int)(l0 >> 32);
        long l1 = OptimisedBytesHash.readIncompleteLong(addrI + 8L, left - 8);
        int l1a = (int)(l1 >> 32);
        long l2 = OptimisedBytesHash.readIncompleteLong(addrI + 16L, left - 16);
        int l2a = (int)(l2 >> 32);
        long l3 = OptimisedBytesHash.readIncompleteLong(addrI + 24L, left - 24);
        int l3a = (int)(l3 >> 32);
        return Maths.agitate((long)(h0 += (l0 + (long)l1a) * 1228037679L + (l2 + (long)l3a) * -189059537L)) ^ Maths.agitate((long)(h1 += (l1 + (long)l0a) * 846538563L + (l3 + (long)l2a) * 1248073673L));
    }

    static long applyAsLongAny(VanillaBytes store, int remaining) {
        int i;
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.address(store.readPosition());
        long h0 = remaining;
        long h1 = 0L;
        for (i = 0; i < remaining - 31; i += 32) {
            h0 *= -978308811L;
            h1 *= 492187003L;
            long addrI = address + (long)i;
            long l0 = MEMORY.readLong(addrI);
            int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
            long l1 = MEMORY.readLong(addrI + 8L);
            int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
            long l2 = MEMORY.readLong(addrI + 16L);
            int l2a = MEMORY.readInt(addrI + 16L + (long)TOP_BYTES);
            long l3 = MEMORY.readLong(addrI + 24L);
            int l3a = MEMORY.readInt(addrI + 24L + (long)TOP_BYTES);
            h0 += (l0 + (long)l1a) * 1228037679L + (l2 + (long)l3a) * -189059537L;
            h1 += (l1 + (long)l0a) * 846538563L + (l3 + (long)l2a) * 1248073673L;
        }
        int left = remaining - i;
        if (left > 0) {
            h0 *= -978308811L;
            h1 *= 492187003L;
            long addrI = address + (long)i;
            if (left <= 16) {
                long l0 = OptimisedBytesHash.readIncompleteLong(addrI, left);
                int l0a = (int)(l0 >> 32);
                long l1 = OptimisedBytesHash.readIncompleteLong(addrI + 8L, left - 8);
                int l1a = (int)(l1 >> 32);
                h0 += (l0 + (long)l1a) * 1228037679L;
                h1 += (l1 + (long)l0a) * 846538563L;
            } else {
                long l0 = MEMORY.readLong(addrI);
                int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
                long l1 = MEMORY.readLong(addrI + 8L);
                int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
                long l2 = OptimisedBytesHash.readIncompleteLong(addrI + 16L, left - 16);
                int l2a = (int)(l2 >> 32);
                long l3 = OptimisedBytesHash.readIncompleteLong(addrI + 24L, left - 24);
                int l3a = (int)(l3 >> 32);
                h0 += (l0 + (long)l1a) * 1228037679L + (l2 + (long)l3a) * -189059537L;
                h1 += (l1 + (long)l0a) * 846538563L + (l3 + (long)l2a) * 1248073673L;
            }
        }
        return Maths.agitate((long)h0) ^ Maths.agitate((long)h1);
    }

    static long readIncompleteLong(long address, int len) {
        if (len >= 8) {
            return MEMORY.readLong(address);
        }
        if (len == 4) {
            return MEMORY.readInt(address);
        }
        long l = 0L;
        for (int i = 0; i < len; ++i) {
            byte b = MEMORY.readByte(address + (long)i);
            l |= (long)(b & 0xFF) << i * 8;
        }
        return l;
    }

    static {
        TOP_BYTES = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 4 : 0;
        MEMORY = OS.memory();
    }
}

