/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.openhft.chronicle.analytics.Analytics;
import net.openhft.chronicle.analytics.internal.AnalyticsConfiguration;
import net.openhft.chronicle.analytics.internal.GoogleAnalytics3;
import net.openhft.chronicle.analytics.internal.GoogleAnalytics4;
import net.openhft.chronicle.analytics.internal.JUnitUtil;
import net.openhft.chronicle.analytics.internal.MuteAnalytics;
import org.jetbrains.annotations.NotNull;

public final class VanillaAnalyticsBuilder
implements Analytics.Builder,
AnalyticsConfiguration {
    private boolean built;
    private final String measurementId;
    private final String apiSecret;
    private final Map<String, String> userProperties = new LinkedHashMap<String, String>();
    private final Map<String, String> eventParameters = new LinkedHashMap<String, String>();
    private Consumer<String> errorLogger = System.err::println;
    private Consumer<String> debugLogger = s -> {};
    private long duration;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private int messages = 0;
    private String clientIdFileName = Optional.ofNullable(System.getProperty("user.home")).orElse(".") + "/.chronicle.analytics.client.id";
    private String url = "https://www.google-analytics.com/mp/collect";
    private boolean reportDespiteJUnit;

    public VanillaAnalyticsBuilder(@NotNull String measurementId, @NotNull String apiSecret) {
        this.measurementId = measurementId;
        this.apiSecret = apiSecret;
    }

    @Override
    @NotNull
    public Analytics.Builder putUserProperty(@NotNull String key, @NotNull String value) {
        this.userProperties.put(key, value);
        return this;
    }

    @Override
    @NotNull
    public Analytics.Builder putEventParameter(@NotNull String key, @NotNull String value) {
        this.eventParameters.put(key, value);
        return this;
    }

    @Override
    @NotNull
    public Analytics.Builder withFrequencyLimit(int messages, long duration, @NotNull TimeUnit timeUnit) {
        if (messages < 0) {
            throw new IllegalArgumentException("messages must not be negative, was " + messages);
        }
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must not be negative, was " + duration);
        }
        this.messages = messages;
        this.duration = duration;
        this.timeUnit = timeUnit;
        return this;
    }

    @Override
    public @NotNull Analytics.Builder withErrorLogger(@NotNull Consumer<String> errorLogger) {
        this.errorLogger = errorLogger;
        return this;
    }

    @Override
    public @NotNull Analytics.Builder withDebugLogger(@NotNull Consumer<String> debugLogger) {
        this.debugLogger = debugLogger;
        return this;
    }

    @Override
    public @NotNull Analytics.Builder withClientIdFileName(@NotNull String clientIdFileName) {
        this.clientIdFileName = clientIdFileName;
        return this;
    }

    @Override
    public @NotNull Analytics.Builder withUrl(@NotNull String url) {
        this.url = url;
        return this;
    }

    @Override
    public @NotNull Analytics.Builder withReportDespiteJUnit() {
        this.reportDespiteJUnit = true;
        return this;
    }

    @Override
    @NotNull
    public Analytics build() {
        if (this.built) {
            throw new IllegalStateException("This builder has already been used.");
        }
        this.built = true;
        if (JUnitUtil.isJUnitAvailable() && !this.reportDespiteJUnit) {
            return MuteAnalytics.INSTANCE;
        }
        if (this.measurementId.startsWith("UA-")) {
            return new GoogleAnalytics3(this);
        }
        return new GoogleAnalytics4(this);
    }

    @Override
    @NotNull
    public String measurementId() {
        return this.measurementId;
    }

    @Override
    @NotNull
    public String apiSecret() {
        return this.apiSecret;
    }

    @Override
    @NotNull
    public Map<String, String> userProperties() {
        return this.userProperties;
    }

    @Override
    @NotNull
    public Map<String, String> eventParameters() {
        return this.eventParameters;
    }

    @Override
    @NotNull
    public Consumer<String> errorLogger() {
        return this.errorLogger;
    }

    @Override
    @NotNull
    public Consumer<String> debugLogger() {
        return this.debugLogger;
    }

    @Override
    public int messages() {
        return this.messages;
    }

    @Override
    public long duration() {
        return this.duration;
    }

    @Override
    @NotNull
    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    @Override
    @NotNull
    public String clientIdFileName() {
        return this.clientIdFileName;
    }

    @Override
    @NotNull
    public String url() {
        return this.url;
    }
}

