/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import java.lang.reflect.Field;
import net.openhft.chronicle.algo.bytes.Accessor;
import net.openhft.chronicle.algo.bytes.ArrayAccessors;
import net.openhft.chronicle.algo.bytes.NativeAccess;
import net.openhft.chronicle.algo.bytes.ReadAccess;

final class HotSpotStringAccessor<T>
implements Accessor.Read<String, T> {
    public static final HotSpotStringAccessor<char[]> JAVA8 = new HotSpotStringAccessor();
    public static final HotSpotStringAccessor<byte[]> JAVA9PLUS = new HotSpotStringAccessor();
    private static final long valueOffset;

    private HotSpotStringAccessor() {
    }

    @Override
    public ReadAccess<T> access() {
        return NativeAccess.instance();
    }

    @Override
    public T handle(String source) {
        return (T)NativeAccess.U.getObject(source, valueOffset);
    }

    @Override
    public long offset(String source, long index) {
        return ArrayAccessors.Char.INSTANCE.offset(null, index);
    }

    @Override
    public long size(long size) {
        return size * 2L;
    }

    static {
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueOffset = NativeAccess.U.objectFieldOffset(valueField);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

