/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bitset;

import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetAlgorithm;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.FlatBitSetAlgorithm;
import net.openhft.chronicle.algo.bytes.Access;

public final class SingleThreadedFlatBitSetFrame
implements BitSetFrame {
    public static final long ALL_ONES = -1L;
    private final long longLength;

    public SingleThreadedFlatBitSetFrame(long logicalSize) {
        if (logicalSize <= 0L) {
            throw new IllegalArgumentException("Logical size should be positive, " + logicalSize + " given");
        }
        this.longLength = MemoryUnit.BITS.toLongs(logicalSize);
        if (MemoryUnit.LONGS.toBits(this.longLength) != logicalSize) {
            throw new IllegalArgumentException("logical size should be long-aligned (i. e. a multiple of 8), " + logicalSize + " given");
        }
    }

    static long singleBit(long bitIndex) {
        return 1L << (int)bitIndex;
    }

    static long higherBitsIncludingThis(long bitIndex) {
        return -1L << (int)bitIndex;
    }

    static long lowerBitsIncludingThis(long bitIndex) {
        return -1L >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static long higherBitsExcludingThis(long bitIndex) {
        return -1L >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    static long lowerBitsExcludingThis(long bitIndex) {
        return -1L << (int)bitIndex ^ 0xFFFFFFFFFFFFFFFFL;
    }

    static long longWithThisBit(long bitIndex) {
        return bitIndex >> 6;
    }

    static long firstByte(long offset, long longIndex) {
        return offset + (longIndex << 3);
    }

    static long firstBit(long longIndex) {
        return longIndex << 6;
    }

    static long lastBit(long longIndex) {
        return SingleThreadedFlatBitSetFrame.firstBit(longIndex) + 63L;
    }

    static void checkNumberOfBits(int numberOfBits) {
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException("Illegal number of bits: " + numberOfBits);
        }
    }

    static boolean checkNotFoundIndex(long fromIndex) {
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return true;
            }
            throw new IndexOutOfBoundsException("from index: " + fromIndex);
        }
        return false;
    }

    static void checkFromIndex(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException("from index: " + fromIndex);
        }
    }

    long byteWithThisBit(long offset, long bitIndex) {
        return offset + (bitIndex >> 6 << 3);
    }

    private boolean checkIndex(long bitIndex) {
        if (bitIndex < 0L || bitIndex >> 6 >= this.longLength) {
            throw new IndexOutOfBoundsException("index: " + bitIndex + ", logical size: " + MemoryUnit.LONGS.toBits(this.longLength));
        }
        return true;
    }

    private boolean checkFromTo(long fromIndex, long exclusiveToIndex, long toLongIndex) {
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException("index range: [" + fromIndex + ", " + exclusiveToIndex + "), " + "logical size: " + MemoryUnit.LONGS.toBits(this.longLength));
        }
        return true;
    }

    private <T> long readLong(Access<T> access, T handle, long offset, long longIndex) {
        return access.readLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex));
    }

    private <T> void writeLong(Access<T> access, T handle, long offset, long longIndex, long toWrite) {
        access.writeLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex), toWrite);
    }

    @Override
    public <T> void flip(Access<T> access, T handle, long offset, long bitIndex) {
        assert (this.checkIndex(bitIndex));
        long byteIndex = this.byteWithThisBit(offset, bitIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        long l = access.readLong(handle, byteIndex);
        long l2 = l ^ mask;
        access.writeLong(handle, byteIndex, l2);
    }

    @Override
    public <T> void flipRange(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
                mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex);
                l = access.readLong(handle, fromByteIndex);
                l2 = l ^ mask;
                access.writeLong(handle, fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.writeLong(access, handle, offset, i, this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.writeLong(access, handle, offset, i, this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                long toByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, toLongIndex);
                mask = SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
                l = access.readLong(handle, toByteIndex);
                l2 = l ^ mask;
                access.writeLong(handle, toByteIndex, l2);
            }
        } else {
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
            long mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
            long l = access.readLong(handle, byteIndex);
            long l2 = l ^ mask;
            access.writeLong(handle, byteIndex, l2);
        }
    }

    @Override
    public <T> void set(Access<T> access, T handle, long offset, long bitIndex) {
        assert (this.checkIndex(bitIndex));
        long byteIndex = this.byteWithThisBit(offset, bitIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        long l = access.readLong(handle, byteIndex);
        if ((l & mask) != 0L) {
            return;
        }
        long l2 = l | mask;
        access.writeLong(handle, byteIndex, l2);
    }

    @Override
    public <T> boolean setIfClear(Access<T> access, T handle, long offset, long bitIndex) {
        long l2;
        assert (this.checkIndex(bitIndex));
        long byteIndex = this.byteWithThisBit(offset, bitIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        long l = access.readLong(handle, byteIndex);
        if (l == (l2 = l | mask)) {
            return false;
        }
        access.writeLong(handle, byteIndex, l2);
        return true;
    }

    @Override
    public <T> void setRange(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
                mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex);
                l = access.readLong(handle, fromByteIndex);
                l2 = l | mask;
                access.writeLong(handle, fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.writeLong(access, handle, offset, i, -1L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.writeLong(access, handle, offset, i, -1L);
                }
                long toByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, toLongIndex);
                mask = SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
                l = access.readLong(handle, toByteIndex);
                l2 = l | mask;
                access.writeLong(handle, toByteIndex, l2);
            }
        } else {
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
            long mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
            long l = access.readLong(handle, byteIndex);
            long l2 = l | mask;
            access.writeLong(handle, byteIndex, l2);
        }
    }

    @Override
    public <T> void setAll(Access<T> access, T handle, long offset) {
        for (long i = 0L; i < this.longLength; ++i) {
            this.writeLong(access, handle, offset, i, -1L);
        }
    }

    @Override
    public <T> void clear(Access<T> access, T handle, long offset, long bitIndex) {
        assert (this.checkIndex(bitIndex));
        long byteIndex = this.byteWithThisBit(offset, bitIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        long l = access.readLong(handle, byteIndex);
        if ((l & mask) == 0L) {
            return;
        }
        long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        access.writeLong(handle, byteIndex, l2);
    }

    @Override
    public <T> boolean clearIfSet(Access<T> access, T handle, long offset, long bitIndex) {
        assert (this.checkIndex(bitIndex));
        long byteIndex = this.byteWithThisBit(offset, bitIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        long l = access.readLong(handle, byteIndex);
        if ((l & mask) == 0L) {
            return false;
        }
        long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        access.writeLong(handle, byteIndex, l2);
        return true;
    }

    @Override
    public <T> void clearRange(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
                mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex);
                l = access.readLong(handle, fromByteIndex);
                l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                access.writeLong(handle, fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.writeLong(access, handle, offset, i, 0L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.writeLong(access, handle, offset, i, 0L);
                }
                long toByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, toLongIndex);
                mask = SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
                l = access.readLong(handle, toByteIndex);
                l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                access.writeLong(handle, toByteIndex, l2);
            }
        } else {
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
            long mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
            long l = access.readLong(handle, byteIndex);
            long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            access.writeLong(handle, byteIndex, l2);
        }
    }

    @Override
    public <T> boolean isRangeSet(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long i;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex);
                if (((this.readLong(access, handle, offset, fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) & mask) != 0L) {
                    return false;
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    if ((this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
                    return false;
                }
                return true;
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                if ((this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
                return false;
            }
            mask = SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
            return ((this.readLong(access, handle, offset, toLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) & mask) == 0L;
        }
        long mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
        return ((this.readLong(access, handle, offset, fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) & mask) == 0L;
    }

    @Override
    public <T> boolean isRangeClear(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long i;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex);
                if ((this.readLong(access, handle, offset, fromLongIndex) & mask) != 0L) {
                    return false;
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    if (this.readLong(access, handle, offset, i) == 0L) continue;
                    return false;
                }
                return true;
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                if (this.readLong(access, handle, offset, i) == 0L) continue;
                return false;
            }
            mask = SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
            return (this.readLong(access, handle, offset, toLongIndex) & mask) == 0L;
        }
        long mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
        return (this.readLong(access, handle, offset, fromLongIndex) & mask) == 0L;
    }

    @Override
    public <T> void clearAll(Access<T> access, T handle, long offset) {
        access.writeBytes(handle, offset, MemoryUnit.LONGS.toBytes(this.longLength), (byte)0);
    }

    @Override
    public <T> boolean get(Access<T> access, T handle, long offset, long bitIndex) {
        assert (this.checkIndex(bitIndex));
        long byteIndex = this.byteWithThisBit(offset, bitIndex);
        long l = access.readLong(handle, byteIndex);
        return (l & SingleThreadedFlatBitSetFrame.singleBit(bitIndex)) != 0L;
    }

    @Override
    public <T> long nextSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = this.readLong(access, handle, offset, fromLongIndex) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.readLong(access, handle, offset, i);
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public BitSetFrame.Bits setBits() {
        return new SetBits();
    }

    @Override
    public BitSetAlgorithm algorithm() {
        return FlatBitSetAlgorithm.INSTANCE;
    }

    @Override
    public <T> long clearNextSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        long w = access.readLong(handle, fromByteIndex);
        long l = w >>> (int)fromIndex;
        if (l != 0L) {
            long indexOfSetBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
            access.writeLong(handle, fromByteIndex, w ^ mask);
            return indexOfSetBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            l = access.readLong(handle, byteIndex);
            if (l == 0L) continue;
            long indexOfSetBit = SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
            access.writeLong(handle, byteIndex, l ^ mask);
            return indexOfSetBit;
        }
        return -1L;
    }

    @Override
    public <T> long nextClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = (this.readLong(access, handle, offset, fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public <T> long setNextClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        long w = access.readLong(handle, fromByteIndex);
        long l = (w ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            long indexOfClearBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
            access.writeLong(handle, fromByteIndex, w ^ mask);
            return indexOfClearBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            w = access.readLong(handle, byteIndex);
            l = w ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            long indexOfClearBit = SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
            access.writeLong(handle, byteIndex, w ^ mask);
            return indexOfClearBit;
        }
        return -1L;
    }

    @Override
    public <T> long previousSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        if ((l = this.readLong(access, handle, offset, fromLongIndex) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.readLong(access, handle, offset, i);
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    private <T> long previousSetBit(Access<T> access, T handle, long offset, long fromIndex, long inclusiveToIndex) {
        long mask;
        long w;
        long l;
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(inclusiveToIndex);
        assert (this.checkFromTo(inclusiveToIndex, fromIndex + 1L, toLongIndex));
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        if (fromLongIndex != toLongIndex) {
            long l2 = this.readLong(access, handle, offset, fromLongIndex) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL);
            if (l2 != 0L) {
                return fromIndex - (long)Long.numberOfLeadingZeros(l2);
            }
            for (long i = fromLongIndex - 1L; i > toLongIndex; --i) {
                l2 = this.readLong(access, handle, offset, i);
                if (l2 == 0L) continue;
                return SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l2);
            }
            fromIndex = SingleThreadedFlatBitSetFrame.lastBit(toLongIndex);
        }
        if ((l = (w = this.readLong(access, handle, offset, toLongIndex)) & (mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(inclusiveToIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(fromIndex))) != 0L) {
            return SingleThreadedFlatBitSetFrame.lastBit(toLongIndex) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public <T> long clearPreviousSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        long fromByteIndex;
        long w;
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        if ((l = (w = access.readLong(handle, fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex))) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfSetBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
            access.writeLong(handle, fromByteIndex, w ^ mask);
            return indexOfSetBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            l = access.readLong(handle, byteIndex);
            if (l == 0L) continue;
            long indexOfSetBit = SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
            access.writeLong(handle, byteIndex, l ^ mask);
            return indexOfSetBit;
        }
        return -1L;
    }

    @Override
    public <T> long previousClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        if ((l = (this.readLong(access, handle, offset, fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public <T> long setPreviousClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        long fromByteIndex;
        long w;
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        if ((l = ((w = access.readLong(handle, fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex))) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfClearBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
            access.writeLong(handle, fromByteIndex, w ^ mask);
            return indexOfClearBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            w = access.readLong(handle, byteIndex);
            l = w ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            long indexOfClearBit = SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
            access.writeLong(handle, byteIndex, w ^ mask);
            return indexOfClearBit;
        }
        return -1L;
    }

    @Override
    public long logicalSize() {
        return MemoryUnit.LONGS.toBits(this.longLength);
    }

    @Override
    public long sizeInBytes() {
        return MemoryUnit.LONGS.toBytes(this.longLength);
    }

    @Override
    public <T> long cardinality(Access<T> access, T handle, long offset) {
        long count = 0L;
        for (long i = 0L; i < this.longLength; ++i) {
            count += (long)Long.bitCount(this.readLong(access, handle, offset, i));
        }
        return count;
    }

    @Override
    public <T> long setNextNContinuousClearBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        if (numberOfBits > 64) {
            return this.setNextManyContinuousClearBits(access, handle, offset, fromIndex, numberOfBits);
        }
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.setNextClearBit(access, handle, offset, fromIndex);
        }
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long nTrailingOnes = -1L >>> 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex2 = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        if (longIndex2 >= this.longLength) {
            return -1L;
        }
        int bitsFromFirstWord = 64 - ((int)bitIndex & 0x3F);
        long byteIndex2 = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex2);
        long w2 = access.readLong(handle, byteIndex2);
        block0: while (true) {
            long w1 = w2;
            byteIndex2 += 8L;
            if (++longIndex2 < this.longLength) {
                w2 = access.readLong(handle, byteIndex2);
            } else if (longIndex2 == this.longLength) {
                w2 = -1L;
            } else {
                return -1L;
            }
            long l = bitsFromFirstWord != 64 ? w1 >>> (int)bitIndex | w2 << bitsFromFirstWord : w1;
            if ((l & 1L) != 0L) {
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x != 0L) {
                    int trailingOnes = Long.numberOfTrailingZeros(x);
                    bitIndex += (long)trailingOnes;
                    if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                        bitsFromFirstWord += 64;
                        continue;
                    }
                    l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                } else {
                    bitIndex += 64L;
                    continue;
                }
            }
            while (true) {
                if ((l & nTrailingOnes) == 0L) {
                    long mask1 = nTrailingOnes << (int)bitIndex;
                    access.writeLong(handle, byteIndex2 - 8L, w1 ^ mask1);
                    int bitsFromSecondWordToSwitch = numberOfBits - bitsFromFirstWord;
                    if (bitsFromSecondWordToSwitch > 0) {
                        long mask2 = SingleThreadedFlatBitSetFrame.singleBit(bitsFromSecondWordToSwitch) - 1L;
                        access.writeLong(handle, byteIndex2, w2 ^ mask2);
                    }
                    return bitIndex;
                }
                int trailingZeros = Long.numberOfTrailingZeros(l);
                bitIndex += (long)trailingZeros;
                if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x == 0L) break;
                int trailingOnes = Long.numberOfTrailingZeros(x);
                bitIndex += (long)trailingOnes;
                if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
            }
            bitIndex += 64L;
        }
    }

    private <T> long setNextManyContinuousClearBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        long size = this.logicalSize();
        long testFromIndex = fromIndex;
        long limit;
        while ((limit = fromIndex + (long)numberOfBits) <= size) {
            long needToBeZerosUntil = limit - 1L;
            long lastSetBit = this.previousSetBit(access, handle, offset, needToBeZerosUntil, testFromIndex);
            if (lastSetBit == -1L) {
                this.setRange(access, handle, offset, fromIndex, limit);
                return fromIndex;
            }
            fromIndex = lastSetBit + 1L;
            testFromIndex = limit;
        }
        return -1L;
    }

    @Override
    public <T> long clearNextNContinuousSetBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.clearNextSetBit(access, handle, offset, fromIndex);
        }
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long nTrailingOnes = -1L >>> 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex2 = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        if (longIndex2 >= this.longLength) {
            return -1L;
        }
        int bitsFromFirstWord = 64 - ((int)bitIndex & 0x3F);
        long byteIndex2 = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex2);
        long w2 = access.readLong(handle, byteIndex2);
        block0: while (true) {
            long w1 = w2;
            byteIndex2 += 8L;
            if (++longIndex2 < this.longLength) {
                w2 = access.readLong(handle, byteIndex2);
            } else if (longIndex2 == this.longLength) {
                w2 = 0L;
            } else {
                return -1L;
            }
            long l = bitsFromFirstWord != 64 ? w1 >>> (int)bitIndex | w2 << bitsFromFirstWord : w1;
            if ((l & 1L) == 0L) {
                if (l != 0L) {
                    int trailingZeros = Long.numberOfTrailingZeros(l);
                    bitIndex += (long)trailingZeros;
                    if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                        bitsFromFirstWord += 64;
                        continue;
                    }
                    l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                } else {
                    bitIndex += 64L;
                    continue;
                }
            }
            while (true) {
                if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nTrailingOnes) == 0L) {
                    long mask1 = nTrailingOnes << (int)bitIndex;
                    access.writeLong(handle, byteIndex2 - 8L, w1 ^ mask1);
                    int bitsFromSecondWordToSwitch = numberOfBits - bitsFromFirstWord;
                    if (bitsFromSecondWordToSwitch > 0) {
                        long mask2 = SingleThreadedFlatBitSetFrame.singleBit(bitsFromSecondWordToSwitch) - 1L;
                        access.writeLong(handle, byteIndex2, w2 ^ mask2);
                    }
                    return bitIndex;
                }
                int trailingOnes = Long.numberOfTrailingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                bitIndex += (long)trailingOnes;
                if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                if (l == 0L) break;
                int trailingZeros = Long.numberOfTrailingZeros(l);
                bitIndex += (long)trailingZeros;
                if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
            }
            bitIndex += 64L;
        }
    }

    @Override
    public <T> long setPreviousNContinuousClearBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.setPreviousClearBit(access, handle, offset, fromIndex);
        }
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        int n64Complement = 64 - numberOfBits;
        long nLeadingOnes = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(n64Complement);
        long higherBitBound = fromIndex + 1L;
        long lowLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (lowLongIndex >= this.longLength) {
            lowLongIndex = this.longLength - 1L;
            higherBitBound = this.longLength << 6;
        }
        int bitsFromLowWord = 64 - ((int)higherBitBound & 0x3F) & 0x3F;
        long lowByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, lowLongIndex);
        long lw = access.readLong(handle, lowByteIndex);
        block0: while (true) {
            long hw = lw;
            lowByteIndex -= 8L;
            if (--lowLongIndex >= 0L) {
                lw = access.readLong(handle, lowByteIndex);
            } else if (lowLongIndex == -1L) {
                lw = -1L;
            } else {
                return -1L;
            }
            long l = bitsFromLowWord != 0 ? lw >>> (int)higherBitBound | hw << bitsFromLowWord : hw;
            if (l < 0L) {
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x != 0L) {
                    int leadingOnes = Long.numberOfLeadingZeros(x);
                    higherBitBound -= (long)leadingOnes;
                    int flw = (bitsFromLowWord += leadingOnes) - 64;
                    if (flw >= 0) {
                        bitsFromLowWord = flw;
                        continue;
                    }
                    l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                } else {
                    higherBitBound -= 64L;
                    continue;
                }
            }
            while (true) {
                if ((l & nLeadingOnes) == 0L) {
                    long hMask = nLeadingOnes >>> bitsFromLowWord;
                    access.writeLong(handle, lowByteIndex + 8L, hw ^ hMask);
                    int bitsFromLowWordToSwitch = bitsFromLowWord - n64Complement;
                    if (bitsFromLowWordToSwitch > 0) {
                        long lMask = -1L >>> bitsFromLowWordToSwitch ^ 0xFFFFFFFFFFFFFFFFL;
                        access.writeLong(handle, lowByteIndex, lw ^ lMask);
                    }
                    return higherBitBound - (long)numberOfBits;
                }
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                int flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x == 0L) break;
                int leadingOnes = Long.numberOfLeadingZeros(x);
                higherBitBound -= (long)leadingOnes;
                flw = (bitsFromLowWord += leadingOnes) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            }
            higherBitBound -= 64L;
        }
    }

    @Override
    public <T> long clearPreviousNContinuousSetBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.clearPreviousSetBit(access, handle, offset, fromIndex);
        }
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        int n64Complement = 64 - numberOfBits;
        long nLeadingOnes = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(n64Complement);
        long higherBitBound = fromIndex + 1L;
        long lowLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (lowLongIndex >= this.longLength) {
            lowLongIndex = this.longLength - 1L;
            higherBitBound = this.longLength << 6;
        }
        int bitsFromLowWord = 64 - ((int)higherBitBound & 0x3F) & 0x3F;
        long lowByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, lowLongIndex);
        long lw = access.readLong(handle, lowByteIndex);
        block0: while (true) {
            int flw;
            long hw = lw;
            lowByteIndex -= 8L;
            if (--lowLongIndex >= 0L) {
                lw = access.readLong(handle, lowByteIndex);
            } else if (lowLongIndex == -1L) {
                lw = 0L;
            } else {
                return -1L;
            }
            long l = bitsFromLowWord != 0 ? lw >>> (int)higherBitBound | hw << bitsFromLowWord : hw;
            if (l > 0L) {
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            } else if (l == 0L) {
                higherBitBound -= 64L;
                continue;
            }
            while (true) {
                if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nLeadingOnes) == 0L) {
                    long hMask = nLeadingOnes >>> bitsFromLowWord;
                    access.writeLong(handle, lowByteIndex + 8L, hw ^ hMask);
                    int bitsFromLowWordToSwitch = bitsFromLowWord - n64Complement;
                    if (bitsFromLowWordToSwitch > 0) {
                        long lMask = -1L >>> bitsFromLowWordToSwitch ^ 0xFFFFFFFFFFFFFFFFL;
                        access.writeLong(handle, lowByteIndex, lw ^ lMask);
                    }
                    return higherBitBound - (long)numberOfBits;
                }
                int leadingOnes = Long.numberOfLeadingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                higherBitBound -= (long)leadingOnes;
                flw = (bitsFromLowWord += leadingOnes) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                if (l == 0L) break;
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            }
            higherBitBound -= 64L;
        }
    }

    private class SetBits
    implements BitSetFrame.Bits {
        private final long byteLength;
        private long byteIndex;
        private long bitIndex;
        private long currentWord;

        private SetBits() {
            this.byteLength = SingleThreadedFlatBitSetFrame.this.longLength << 3;
        }

        @Override
        public <T> BitSetFrame.Bits reset(Access<T> access, T handle, long offset) {
            this.byteIndex = 0L;
            this.bitIndex = -1L;
            this.currentWord = access.readLong(handle, offset);
            return this;
        }

        @Override
        public <T> long next(Access<T> access, T handle, long offset) {
            long l = this.currentWord;
            if (l != 0L) {
                int trailingZeros = Long.numberOfTrailingZeros(l);
                this.currentWord = l >>> trailingZeros >>> 1;
                return this.bitIndex += (long)(trailingZeros + 1);
            }
            long i = this.byteIndex;
            long lim = this.byteLength;
            while ((i += 8L) < lim) {
                l = access.readLong(handle, i);
                if (l == 0L) continue;
                this.byteIndex = i;
                int trailingZeros = Long.numberOfTrailingZeros(l);
                this.currentWord = l >>> trailingZeros >>> 1;
                this.bitIndex = (i << 3) + (long)trailingZeros;
                return this.bitIndex;
            }
            this.currentWord = 0L;
            this.byteIndex = this.byteLength;
            return -1L;
        }
    }
}

