/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bitset;

import net.openhft.chronicle.algo.bitset.BitSet;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.bytes.Access;

public class ReusableBitSet
implements BitSet {
    protected BitSetFrame frame;
    protected Access access;
    protected Object handle;
    protected long offset;

    public <T> ReusableBitSet(BitSetFrame frame, Access<T> access, T handle, long offset) {
        this.reuse(frame, access, handle, offset);
    }

    public <T> ReusableBitSet reuse(BitSetFrame frame, Access<T> access, T handle, long offset) {
        this.frame = frame;
        this.access = access;
        this.handle = handle;
        this.offset = offset;
        return this;
    }

    @Override
    public void flip(long bitIndex) {
        this.frame.flip(this.access, this.handle, this.offset, bitIndex);
    }

    @Override
    public void flipRange(long fromIndex, long toIndex) {
        this.frame.flipRange(this.access, this.handle, this.offset, fromIndex, toIndex);
    }

    @Override
    public void set(long bitIndex) {
        this.frame.set(this.access, this.handle, this.offset, bitIndex);
    }

    @Override
    public boolean setIfClear(long bitIndex) {
        return this.frame.setIfClear(this.access, this.handle, this.offset, bitIndex);
    }

    @Override
    public boolean clearIfSet(long bitIndex) {
        return this.frame.clearIfSet(this.access, this.handle, this.offset, bitIndex);
    }

    @Override
    public void setRange(long fromIndex, long toIndex) {
        this.frame.setRange(this.access, this.handle, this.offset, fromIndex, toIndex);
    }

    @Override
    public boolean isRangeSet(long fromIndex, long toIndex) {
        return this.frame.isRangeSet(this.access, this.handle, this.offset, fromIndex, toIndex);
    }

    @Override
    public void setAll() {
        this.frame.setAll(this.access, this.handle, this.offset);
    }

    @Override
    public void clear(long bitIndex) {
        this.frame.clear(this.access, this.handle, this.offset, bitIndex);
    }

    @Override
    public void clearRange(long fromIndex, long toIndex) {
        this.frame.clearRange(this.access, this.handle, this.offset, fromIndex, toIndex);
    }

    @Override
    public boolean isRangeClear(long fromIndex, long toIndex) {
        return this.frame.isRangeClear(this.access, this.handle, this.offset, fromIndex, toIndex);
    }

    @Override
    public void clearAll() {
        this.frame.clearAll(this.access, this.handle, this.offset);
    }

    @Override
    public boolean get(long bitIndex) {
        return this.frame.get(this.access, this.handle, this.offset, bitIndex);
    }

    @Override
    public long nextSetBit(long fromIndex) {
        return this.frame.nextSetBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long nextClearBit(long fromIndex) {
        return this.frame.nextClearBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long previousSetBit(long fromIndex) {
        return this.frame.previousSetBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long previousClearBit(long fromIndex) {
        return this.frame.previousClearBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long logicalSize() {
        return this.frame.logicalSize();
    }

    @Override
    public long cardinality() {
        return this.frame.cardinality(this.access, this.handle, this.offset);
    }

    @Override
    public long setNextClearBit(long fromIndex) {
        return this.frame.setNextClearBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long clearNextSetBit(long fromIndex) {
        return this.frame.clearNextSetBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long setPreviousClearBit(long fromIndex) {
        return this.frame.setPreviousClearBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long clearPreviousSetBit(long fromIndex) {
        return this.frame.clearPreviousSetBit(this.access, this.handle, this.offset, fromIndex);
    }

    @Override
    public long setNextNContinuousClearBits(long fromIndex, int numberOfBits) {
        return this.frame.setNextNContinuousClearBits(this.access, this.handle, this.offset, fromIndex, numberOfBits);
    }

    @Override
    public long clearNextNContinuousSetBits(long fromIndex, int numberOfBits) {
        return this.frame.clearNextNContinuousSetBits(this.access, this.handle, this.offset, fromIndex, numberOfBits);
    }

    @Override
    public long setPreviousNContinuousClearBits(long fromIndex, int numberOfBits) {
        return this.frame.setPreviousNContinuousClearBits(this.access, this.handle, this.offset, fromIndex, numberOfBits);
    }

    @Override
    public long clearPreviousNContinuousSetBits(long fromIndex, int numberOfBits) {
        return this.frame.clearPreviousNContinuousSetBits(this.access, this.handle, this.offset, fromIndex, numberOfBits);
    }

    @Override
    public Bits setBits() {
        return new Bits(this.frame.setBits());
    }

    protected class Bits
    implements BitSet.Bits {
        protected BitSetFrame.Bits frameBits;

        public Bits(BitSetFrame.Bits frameBits) {
            this.frameBits = frameBits;
        }

        @Override
        public BitSet.Bits reset() {
            this.frameBits.reset(ReusableBitSet.this.access, ReusableBitSet.this.handle, ReusableBitSet.this.offset);
            return this;
        }

        @Override
        public long next() {
            return this.frameBits.next(ReusableBitSet.this.access, ReusableBitSet.this.handle, ReusableBitSet.this.offset);
        }
    }
}

