/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.PrintStream;
import net.openhft.affinity.AffinityLock;

public class MicroJitterSampler {
    private static final long[] DELAY = new long[]{2000L, 3000L, 4000L, 6000L, 8000L, 10000L, 14000L, 20000L, 30000L, 40000L, 60000L, 80000L, 100000L, 140000L, 200000L, 300000L, 400000L, 600000L, 800000L, 1000000L, 2000000L, 5000000L, 10000000L, 20000000L, 50000000L, 100000000L};
    private static final double UTIL = Double.parseDouble(System.getProperty("util", "50"));
    private static final boolean BUSYWAIT = Boolean.parseBoolean(System.getProperty("busywait", "false"));
    private static final String CPU = System.getProperty("cpu", "none");
    private final int[] count = new int[DELAY.length];
    private long totalTime = 0L;

    private static void pause() throws InterruptedException {
        if (BUSYWAIT) {
            long now = System.nanoTime();
            while (System.nanoTime() - now < 1000000L) {
            }
        } else {
            Thread.sleep(1L);
        }
    }

    public static void main(String ... ignored) throws InterruptedException {
        MicroJitterSampler sampler = new MicroJitterSampler();
        Thread t = new Thread(sampler::run);
        t.start();
        t.join();
    }

    private void once() throws InterruptedException {
        if (UTIL >= 100.0) {
            this.sample(30000000000L);
        } else {
            long sampleLength = (long)((1.0 / (1.0 - UTIL / 100.0) - 1.0) * 1000.0 * 1000.0);
            for (int i = 0; i < 30000; i += 2) {
                this.sample(sampleLength);
                MicroJitterSampler.pause();
            }
        }
    }

    public void run() {
        try (AffinityLock lock = AffinityLock.acquireLock(CPU);){
            assert (lock != null);
            boolean first = true;
            System.out.println("Warming up...");
            while (!Thread.currentThread().isInterrupted()) {
                this.once();
                if (first) {
                    this.reset();
                    first = false;
                    System.out.println("Warmup complete. Running jitter tests...");
                    continue;
                }
                this.print(System.out);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static String asString(long timeNS) {
        return timeNS < 1000L ? timeNS + "ns" : (timeNS < 1000000L ? timeNS / 1000L + "us" : (timeNS < 1000000000L ? timeNS / 1000000L + "ms" : timeNS / 1000000000L + "sec"));
    }

    void reset() {
        for (int i = 0; i < DELAY.length; ++i) {
            this.count[i] = 0;
        }
        this.totalTime = 0L;
    }

    void sample(long intervalNS) {
        long now;
        long prev = System.nanoTime();
        long end = prev + intervalNS;
        do {
            long time;
            if ((time = (now = System.nanoTime()) - prev) >= DELAY[0]) {
                int i;
                for (i = 1; i < DELAY.length && time >= DELAY[i]; ++i) {
                }
                int n = i - 1;
                this.count[n] = this.count[n] + 1;
            }
            prev = now;
        } while (now < end);
        this.totalTime += intervalNS;
    }

    void print(PrintStream ps) {
        ps.println("After " + this.totalTime / 1000000000L + " seconds, the average per hour was");
        for (int i = 0; i < DELAY.length; ++i) {
            if (this.count[i] < 1) continue;
            long countPerHour = (long)Math.ceil((double)this.count[i] * 3.6E12 / (double)this.totalTime);
            ps.println(MicroJitterSampler.asString(DELAY[i]) + '\t' + countPerHour);
        }
        ps.println();
    }
}

