/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.util.concurrent.ThreadFactory;
import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.AffinityStrategies;
import net.openhft.affinity.AffinityStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AffinityThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    @NotNull
    private final AffinityStrategy[] strategies;
    @Nullable
    private AffinityLock lastAffinityLock = null;
    private int id = 1;

    public AffinityThreadFactory(String name, AffinityStrategy ... strategies) {
        this(name, true, strategies);
    }

    public AffinityThreadFactory(String name, boolean daemon, AffinityStrategy ... strategies) {
        AffinityStrategy[] affinityStrategyArray;
        this.name = name;
        this.daemon = daemon;
        if (strategies.length == 0) {
            AffinityStrategy[] affinityStrategyArray2 = new AffinityStrategy[1];
            affinityStrategyArray = affinityStrategyArray2;
            affinityStrategyArray2[0] = AffinityStrategies.ANY;
        } else {
            affinityStrategyArray = strategies;
        }
        this.strategies = affinityStrategyArray;
    }

    @Override
    @NotNull
    public synchronized Thread newThread(final @NotNull Runnable r) {
        String name2 = this.id <= 1 ? this.name : this.name + '-' + this.id;
        ++this.id;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try (AffinityLock ignored = AffinityThreadFactory.this.acquireLockBasedOnLast();){
                    assert (ignored != null);
                    r.run();
                }
            }
        }, name2);
        t.setDaemon(this.daemon);
        return t;
    }

    private synchronized AffinityLock acquireLockBasedOnLast() {
        AffinityLock al = this.lastAffinityLock == null ? AffinityLock.acquireLock(false) : this.lastAffinityLock.acquireLock(this.strategies);
        al.bind();
        if (al.cpuId() >= 0) {
            this.lastAffinityLock = al;
        }
        return al;
    }
}

