/*
 * Decompiled with CFR 0.152.
 */
package software.chronicle.enterprise.internals.impl;

import java.util.BitSet;
import net.openhft.affinity.IAffinity;

public enum NativeAffinity implements IAffinity
{
    INSTANCE;

    public static final boolean LOADED;

    private static native byte[] getAffinity0();

    private static native void setAffinity0(byte[] var0);

    private static native int getCpu0();

    private static native int getProcessId0();

    private static native int getThreadId0();

    private static native long rdtsc0();

    private static boolean loadAffinityNativeLibrary() {
        try {
            System.loadLibrary("CEInternals");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    @Override
    public BitSet getAffinity() {
        byte[] buff = NativeAffinity.getAffinity0();
        if (buff == null) {
            return null;
        }
        return BitSet.valueOf(buff);
    }

    @Override
    public void setAffinity(BitSet affinity) {
        NativeAffinity.setAffinity0(affinity.toByteArray());
    }

    @Override
    public int getCpu() {
        return NativeAffinity.getCpu0();
    }

    @Override
    public int getProcessId() {
        return NativeAffinity.getProcessId0();
    }

    @Override
    public int getThreadId() {
        return NativeAffinity.getThreadId0();
    }

    static {
        LOADED = NativeAffinity.loadAffinityNativeLibrary();
    }
}

