/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.lockchecker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.openhft.affinity.lockchecker.LockChecker;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedLockChecker
implements LockChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedLockChecker.class);
    protected static final SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z");
    private static final LockChecker instance = new FileBasedLockChecker();

    public static LockChecker getInstance() {
        return instance;
    }

    protected FileBasedLockChecker() {
    }

    @Override
    public boolean isLockFree(int id) {
        return !this.toFile(id).exists();
    }

    @Override
    public boolean obtainLock(int id, String metaInfo) throws IOException {
        File file = this.toFile(id);
        file.delete();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "utf-8"));){
            writer.write(metaInfo + "\n" + df.format(new Date()));
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean releaseLock(int id) {
        return this.toFile(id).delete();
    }

    @Override
    public String getMetaInfo(int id) throws IOException {
        File file = this.toFile(id);
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));){
            String firstLine = reader.readLine();
            if (firstLine == null) {
                LOGGER.error(String.format("Empty lock file %s%n", file.getAbsolutePath()));
                String string = null;
                return string;
            }
            String string = firstLine.trim();
            return string;
        }
    }

    @NotNull
    protected File toFile(int id) {
        return new File(FileBasedLockChecker.tmpDir(), "cpu-" + id + ".lock");
    }

    static File tmpDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return tempDir;
    }
}

