/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import net.openhft.affinity.IAffinity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PosixJNAAffinity
extends Enum<PosixJNAAffinity>
implements IAffinity {
    public static final /* enum */ PosixJNAAffinity INSTANCE;
    public static final boolean LOADED;
    private static final Logger LOGGER;
    private static final String LIBRARY_NAME;
    private static final int PROCESS_ID;
    private final ThreadLocal<Integer> THREAD_ID = new ThreadLocal();
    private static final boolean ISLINUX;
    private static final boolean IS64BIT;
    private static final int SYS_gettid;
    private static final Object[] NO_ARGS;
    private static final /* synthetic */ PosixJNAAffinity[] $VALUES;

    public static PosixJNAAffinity[] values() {
        return (PosixJNAAffinity[])$VALUES.clone();
    }

    public static PosixJNAAffinity valueOf(String name) {
        return Enum.valueOf(PosixJNAAffinity.class, name);
    }

    @Override
    public BitSet getAffinity() {
        CLibrary lib = CLibrary.INSTANCE;
        int procs = Runtime.getRuntime().availableProcessors();
        int cpuSetSizeInLongs = (procs + 63) / 64;
        int cpuSetSizeInBytes = cpuSetSizeInLongs * 8;
        Memory cpusetArray = new Memory((long)cpuSetSizeInBytes);
        PointerByReference cpuset = new PointerByReference((Pointer)cpusetArray);
        try {
            int ret = lib.sched_getaffinity(0, cpuSetSizeInBytes, (PointerType)cpuset);
            if (ret < 0) {
                throw new IllegalStateException("sched_getaffinity((" + cpuSetSizeInBytes + ") , &(" + cpusetArray + ") ) return " + ret);
            }
            ByteBuffer buff = cpusetArray.getByteBuffer(0L, (long)cpuSetSizeInBytes);
            return BitSet.valueOf(buff.array());
        }
        catch (LastErrorException e) {
            if (e.getErrorCode() != 22) {
                throw new IllegalStateException("sched_getaffinity((" + cpuSetSizeInBytes + ") , &(" + cpusetArray + ") ) errorNo=" + e.getErrorCode(), e);
            }
            IntByReference cpuset32 = new IntByReference(0);
            try {
                int ret = lib.sched_getaffinity(0, 4, (PointerType)cpuset32);
                if (ret < 0) {
                    throw new IllegalStateException("sched_getaffinity((4) , &(" + cpuset32 + ") ) return " + ret);
                }
                long[] longs = new long[]{(long)cpuset32.getValue() & 0xFFFFFFFFL};
                return BitSet.valueOf(longs);
            }
            catch (LastErrorException e2) {
                throw new IllegalStateException("sched_getaffinity((4) , &(" + cpuset32 + ") ) errorNo=" + e2.getErrorCode(), e2);
            }
        }
    }

    @Override
    public void setAffinity(BitSet affinity) {
        int value;
        CLibrary lib;
        block8: {
            int procs = Runtime.getRuntime().availableProcessors();
            if (affinity.isEmpty()) {
                throw new IllegalArgumentException("Cannot set zero affinity");
            }
            lib = CLibrary.INSTANCE;
            byte[] buff = affinity.toByteArray();
            int cpuSetSizeInBytes = buff.length;
            Memory cpusetArray = new Memory((long)cpuSetSizeInBytes);
            try {
                cpusetArray.write(0L, buff, 0, buff.length);
                int ret = lib.sched_setaffinity(0, cpuSetSizeInBytes, (PointerType)new PointerByReference((Pointer)cpusetArray));
                if (ret < 0) {
                    throw new IllegalStateException("sched_setaffinity((" + cpuSetSizeInBytes + ") , &(" + affinity + ") ) return " + ret);
                }
            }
            catch (LastErrorException e) {
                if (e.getErrorCode() == 22 && Arrays.equals(buff, cpusetArray.getByteArray(0L, cpuSetSizeInBytes))) break block8;
                throw new IllegalStateException("sched_setaffinity((" + cpuSetSizeInBytes + ") , &(" + affinity + ") ) errorNo=" + e.getErrorCode(), e);
            }
        }
        if ((value = (int)affinity.toLongArray()[0]) == 0) {
            throw new IllegalArgumentException("Cannot set zero affinity");
        }
        IntByReference cpuset32 = new IntByReference(0);
        cpuset32.setValue(value);
        try {
            int ret = lib.sched_setaffinity(0, 4, (PointerType)cpuset32);
            if (ret < 0) {
                throw new IllegalStateException("sched_setaffinity((4) , &(" + Integer.toHexString(cpuset32.getValue()) + ") ) return " + ret);
            }
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_setaffinity((4) , &(" + Integer.toHexString(cpuset32.getValue()) + ") ) errorNo=" + e.getErrorCode(), e);
        }
    }

    @Override
    public int getCpu() {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            int ret = lib.sched_getcpu();
            if (ret < 0) {
                throw new IllegalStateException("sched_getcpu( ) return " + ret);
            }
            return ret;
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getcpu( ) errorNo=" + e.getErrorCode(), e);
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                IntByReference cpu = new IntByReference();
                IntByReference node = new IntByReference();
                int ret = lib.syscall(318, cpu, node, null);
                if (ret != 0) {
                    throw new IllegalStateException("getcpu( ) return " + ret);
                }
                return cpu.getValue();
            }
            catch (LastErrorException lee) {
                throw new IllegalStateException("getcpu( ) errorNo=" + lee.getErrorCode(), lee);
            }
        }
    }

    @Override
    public int getProcessId() {
        return PROCESS_ID;
    }

    @Override
    public int getThreadId() {
        if (ISLINUX) {
            Integer tid = this.THREAD_ID.get();
            if (tid == null) {
                tid = CLibrary.INSTANCE.syscall(SYS_gettid, NO_ARGS);
                this.THREAD_ID.set(tid);
            }
            return tid;
        }
        return -1;
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    static /* synthetic */ String access$000() {
        return LIBRARY_NAME;
    }

    static {
        int processId;
        INSTANCE = new PosixJNAAffinity();
        $VALUES = new PosixJNAAffinity[]{INSTANCE};
        LOGGER = LoggerFactory.getLogger(PosixJNAAffinity.class);
        LIBRARY_NAME = Platform.isWindows() ? "msvcrt" : "c";
        try {
            processId = CLibrary.INSTANCE.getpid();
        }
        catch (Exception ignored) {
            processId = -1;
        }
        PROCESS_ID = processId;
        ISLINUX = "Linux".equals(System.getProperty("os.name"));
        IS64BIT = PosixJNAAffinity.is64Bit0();
        SYS_gettid = PosixJNAAffinity.is64Bit() ? 186 : 224;
        NO_ARGS = new Object[0];
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Unable to load jna library {}", (Throwable)e);
        }
        LOADED = loaded;
    }

    static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)PosixJNAAffinity.access$000(), CLibrary.class);

        public int sched_setaffinity(int var1, int var2, PointerType var3) throws LastErrorException;

        public int sched_getaffinity(int var1, int var2, PointerType var3) throws LastErrorException;

        public int sched_getcpu() throws LastErrorException;

        public int getcpu(IntByReference var1, IntByReference var2, PointerType var3) throws LastErrorException;

        public int getpid() throws LastErrorException;

        public int syscall(int var1, Object ... var2) throws LastErrorException;
    }
}

