/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.URLClassPath;

enum BootClassPath {
    INSTANCE;

    private final URLClassPath bootClassPath = new URLClassPath(this.getBootClassPathURLs());

    public final boolean has(String binaryClassName) {
        String resourceClassName = binaryClassName.replace('.', '/').concat(".class");
        return this.bootClassPath.getResource(resourceClassName, false) != null;
    }

    private URL[] getBootClassPathURLs() {
        Logger LOGGER = LoggerFactory.getLogger(BootClassPath.class);
        try {
            String bootClassPath = System.getProperty("sun.boot.class.path");
            LOGGER.trace("Boot class-path is: {}", (Object)bootClassPath);
            String pathSeparator = System.getProperty("path.separator");
            LOGGER.trace("Path separator is: '{}'", (Object)pathSeparator);
            String[] pathElements = bootClassPath.split(pathSeparator);
            URL[] pathURLs = new URL[pathElements.length];
            for (int i = 0; i < pathElements.length; ++i) {
                pathURLs[i] = new File(pathElements[i]).toURI().toURL();
            }
            return pathURLs;
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Parsing the boot class-path failed! Reason: {}", (Object)e.getMessage());
            return new URL[0];
        }
    }
}

