/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.File;
import java.io.IOException;
import net.openhft.affinity.AffinityStrategies;
import net.openhft.affinity.AffinityStrategy;
import net.openhft.affinity.AffinitySupport;
import net.openhft.affinity.CpuLayout;
import net.openhft.affinity.LockInventory;
import net.openhft.affinity.impl.NoCpuLayout;
import net.openhft.affinity.impl.VanillaCpuLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(AffinityLock.class);
    public static final String AFFINITY_RESERVED = "affinity.reserved";
    public static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static final long BASE_AFFINITY = AffinitySupport.getAffinity();
    public static final long RESERVED_AFFINITY = AffinityLock.getReservedAffinity0();
    private static final LockInventory LOCK_INVENTORY = new LockInventory(new NoCpuLayout(PROCESSORS));
    private final int cpuId;
    private final boolean base;
    private final boolean reservable;
    private final LockInventory lockInventory;
    boolean bound = false;
    @Nullable
    Thread assignedThread;

    public static void cpuLayout(@NotNull CpuLayout cpuLayout) {
        LOCK_INVENTORY.set(cpuLayout);
    }

    @NotNull
    public static CpuLayout cpuLayout() {
        return LOCK_INVENTORY.getCpuLayout();
    }

    private static long getReservedAffinity0() {
        String reservedAffinity = System.getProperty(AFFINITY_RESERVED);
        if (reservedAffinity == null || reservedAffinity.trim().isEmpty()) {
            long reserverable = (long)((1 << PROCESSORS) - 1) ^ BASE_AFFINITY;
            if (reserverable == 0L && PROCESSORS > 1) {
                LOGGER.info("No isolated CPUs found, so assuming CPUs 1 to {} available.", (Object)(PROCESSORS - 1));
                return (1 << PROCESSORS) - 2;
            }
            return reserverable;
        }
        return Long.parseLong(reservedAffinity, 16);
    }

    public static AffinityLock acquireLock() {
        return AffinityLock.acquireLock(true);
    }

    public static AffinityLock acquireCore() {
        return AffinityLock.acquireCore(true);
    }

    public static AffinityLock acquireLock(boolean bind) {
        return AffinityLock.acquireLock(bind, -1, AffinityStrategies.ANY);
    }

    public static AffinityLock acquireCore(boolean bind) {
        return AffinityLock.acquireCore(bind, -1, AffinityStrategies.ANY);
    }

    private static AffinityLock acquireLock(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        return LOCK_INVENTORY.acquireLock(bind, cpuId, strategies);
    }

    private static AffinityLock acquireCore(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        return LOCK_INVENTORY.acquireCore(bind, cpuId, strategies);
    }

    @NotNull
    public static String dumpLocks() {
        return LOCK_INVENTORY.dumpLocks();
    }

    AffinityLock(int cpuId, boolean base, boolean reservable, LockInventory lockInventory) {
        this.lockInventory = lockInventory;
        this.cpuId = cpuId;
        this.base = base;
        this.reservable = reservable;
    }

    final void assignCurrentThread(boolean bind, boolean wholeCore) {
        this.assignedThread = Thread.currentThread();
        if (bind) {
            this.bind(wholeCore);
        }
    }

    public void bind() {
        this.bind(false);
    }

    public void bind(boolean wholeCore) {
        if (this.bound && this.assignedThread != null && this.assignedThread.isAlive()) {
            throw new IllegalStateException("cpu " + this.cpuId + " already bound to " + this.assignedThread);
        }
        if (wholeCore) {
            this.lockInventory.bindWholeCore(this.cpuId);
        } else if (this.cpuId >= 0) {
            this.bound = true;
            this.assignedThread = Thread.currentThread();
            LOGGER.info("Assigning cpu {} to {}", (Object)this.cpuId, (Object)this.assignedThread);
        }
        if (this.cpuId >= 0) {
            AffinitySupport.setAffinity(1L << this.cpuId);
        }
    }

    final boolean canReserve() {
        if (!this.reservable) {
            return false;
        }
        if (this.assignedThread != null) {
            if (this.assignedThread.isAlive()) {
                return false;
            }
            LOGGER.warn("Lock assigned to {} but this thread is dead.", (Object)this.assignedThread);
        }
        return true;
    }

    public AffinityLock acquireLock(AffinityStrategy ... strategies) {
        return AffinityLock.acquireLock(false, this.cpuId, strategies);
    }

    public void release() {
        this.lockInventory.release();
    }

    protected void finalize() throws Throwable {
        if (this.reservable) {
            LOGGER.warn("Affinity lock for {} was discarded rather than release()d in a controlled manner.", (Object)this.assignedThread);
            this.release();
        }
        super.finalize();
    }

    public int cpuId() {
        return this.cpuId;
    }

    public boolean isAllocated() {
        return this.cpuId >= 0;
    }

    public boolean isBound() {
        return this.bound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.assignedThread != null) {
            sb.append(this.assignedThread).append(" alive=").append(this.assignedThread.isAlive());
        } else if (this.reservable) {
            sb.append("Reserved for this application");
        } else if (this.base) {
            sb.append("General use CPU");
        } else {
            sb.append("CPU not available");
        }
        return sb.toString();
    }

    static {
        try {
            if (new File("/proc/cpuinfo").exists()) {
                AffinityLock.cpuLayout(VanillaCpuLayout.fromCpuInfo());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load /proc/cpuinfo", e);
        }
    }
}

