/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.performance;

import com.sun.esb.management.api.performance.PerformanceMeasurementService;
import com.sun.esb.management.base.services.AbstractServiceMBeansImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ComponentStatisticsData;
import com.sun.esb.management.common.data.EndpointStatisticsData;
import com.sun.esb.management.common.data.FrameworkStatisticsData;
import com.sun.esb.management.common.data.NMRStatisticsData;
import com.sun.esb.management.common.data.PerformanceData;
import com.sun.esb.management.common.data.ServiceAssemblyStatisticsData;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import java.io.Serializable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;

public class PerformanceMeasurementServiceMBeanImpl
extends AbstractServiceMBeansImpl
implements PerformanceMeasurementService,
Serializable {
    static final long serialVersionUID = -1L;
    static final String STATISTICS_KEY = "Statistics";

    public PerformanceMeasurementServiceMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    public void clearPeformaceInstrumentationMeasurement(String componentName, String endpoint, String targetName, String targetInstanceName) throws ManagementRemoteException {
        if (!this.isTargetUp(targetName)) {
            return;
        }
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, STATISTICS_KEY, targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (targetInstanceName != null && !instanceName.equals(targetInstanceName) || objectNames == null) continue;
                for (ObjectName objectName : objectNames) {
                    Object[] params = new Object[]{endpoint};
                    String[] signature = new String[]{"java.lang.String"};
                    this.invokeMBeanOperation(objectName, "clearPeformaceInstrumentationMeasurement", params, signature);
                }
            }
        }
    }

    public boolean getPerformanceInstrumentationEnabled(String componentName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        Boolean result = Boolean.FALSE;
        if (!this.isTargetUp(targetName)) {
            return result;
        }
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, STATISTICS_KEY, targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (targetInstanceName != null && !instanceName.equals(targetInstanceName) || objectNames == null) continue;
                for (ObjectName objectName : objectNames) {
                    Object[] params = null;
                    String[] signature = null;
                    result = (Boolean)this.invokeMBeanOperation(objectName, "getPerformanceInstrumentationEnabled", params, signature);
                }
            }
        }
        return result;
    }

    public String getPerformanceInstrumentationMeasurement(String componentName, String endpoint, String targetName, String targetInstanceName) throws ManagementRemoteException {
        String xmlText = null;
        if (!this.isTargetUp(targetName)) {
            return xmlText;
        }
        Map performanceDataMap = null;
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, STATISTICS_KEY, targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (targetInstanceName != null && !instanceName.equals(targetInstanceName) || objectNames == null) continue;
                for (ObjectName objectName : objectNames) {
                    Object[] params = new Object[]{endpoint};
                    String[] signature = new String[]{"java.lang.String"};
                    Object resultObject = this.invokeMBeanOperation(objectName, "getPerformanceInstrumentationMeasurement", params, signature);
                    if (resultObject == null) continue;
                    performanceDataMap = PerformanceData.retrieveDataMap((TabularData)((TabularData)resultObject));
                    xmlText = PerformanceData.convertDataMapToXML((Map)performanceDataMap);
                }
            }
        }
        return xmlText;
    }

    public String[] getPerformanceMeasurementCategories(String componentName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        String[] measurementCategories = null;
        if (!this.isTargetUp(targetName)) {
            return measurementCategories;
        }
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, STATISTICS_KEY, targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (targetInstanceName != null && !instanceName.equals(targetInstanceName) || objectNames == null) continue;
                for (ObjectName objectName : objectNames) {
                    Object[] params = null;
                    String[] signature = null;
                    measurementCategories = (String[])this.invokeMBeanOperation(objectName, "getPerformanceMeasurementCategories", params, signature);
                }
            }
        }
        return measurementCategories;
    }

    public void setPerformanceInstrumentationEnabled(String componentName, boolean flag, String targetName, String targetInstanceName) throws ManagementRemoteException {
        if (!this.isTargetUp(targetName)) {
            return;
        }
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, STATISTICS_KEY, targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (targetInstanceName != null && !instanceName.equals(targetInstanceName) || objectNames == null) continue;
                for (ObjectName objectName : objectNames) {
                    Object[] params = new Object[]{flag};
                    String[] signature = new String[]{"java.lang.boolean"};
                    this.invokeMBeanOperation(objectName, "setPerformanceInstrumentationEnabled", params, signature);
                }
            }
        }
    }

    public String getFrameworkStatistics(String targetName) throws ManagementRemoteException {
        String xmlText = null;
        Map map = null;
        TabularData tabularResult = this.getFrameworkStatisticsAsTabularData(targetName);
        if (tabularResult != null) {
            map = FrameworkStatisticsData.retrieveDataMap((TabularData)tabularResult);
            xmlText = FrameworkStatisticsData.convertDataMapToXML((Map)map);
        }
        return xmlText;
    }

    public TabularData getFrameworkStatisticsAsTabularData(String targetName) throws ManagementRemoteException {
        TabularData tabularResult = null;
        String FRAMEWORK_STATS_METHOD = "getFrameworkStats";
        try {
            tabularResult = (TabularData)this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), FRAMEWORK_STATS_METHOD, new Object[]{targetName}, new String[]{"java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
        return tabularResult;
    }

    public String getComponentStatistics(String componentName, String targetName) throws ManagementRemoteException {
        String xmlText = null;
        Map map = null;
        TabularData tabularResult = this.getComponentStatisticsAsTabularData(componentName, targetName);
        if (tabularResult != null) {
            map = ComponentStatisticsData.retrieveDataMap((TabularData)tabularResult);
            xmlText = ComponentStatisticsData.convertDataMapToXML((Map)map);
        }
        return xmlText;
    }

    public TabularData getComponentStatisticsAsTabularData(String componentName, String targetName) throws ManagementRemoteException {
        String COMPONENT_STATS_METHOD = "getComponentStats";
        TabularData tabularResult = null;
        try {
            tabularResult = (TabularData)this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), COMPONENT_STATS_METHOD, new Object[]{componentName, targetName}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
        return tabularResult;
    }

    public String getEndpointStatistics(String endpointName, String targetName) throws ManagementRemoteException {
        String xmlText = null;
        Map map = null;
        TabularData tabularResult = this.getEndpointStatisticsAsTabularData(endpointName, targetName);
        if (tabularResult != null) {
            map = EndpointStatisticsData.retrieveDataMap((TabularData)tabularResult);
            xmlText = EndpointStatisticsData.convertDataMapToXML((Map)map);
        }
        return xmlText;
    }

    public TabularData getEndpointStatisticsAsTabularData(String endpointName, String targetName) throws ManagementRemoteException {
        TabularData tabularResult = null;
        String ENDPOINT_STATS_METHOD = "getEndpointStats";
        try {
            tabularResult = (TabularData)this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), ENDPOINT_STATS_METHOD, new Object[]{endpointName, targetName}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
        return tabularResult;
    }

    public String getNMRStatistics(String targetName) throws ManagementRemoteException {
        String xmlText = null;
        Map map = null;
        TabularData tabularResult = this.getNMRStatisticsAsTabularData(targetName);
        if (tabularResult != null) {
            map = NMRStatisticsData.retrieveDataMap((TabularData)tabularResult);
            xmlText = NMRStatisticsData.convertDataMapToXML((Map)map);
        }
        return xmlText;
    }

    public TabularData getNMRStatisticsAsTabularData(String targetName) throws ManagementRemoteException {
        TabularData tabularResult = null;
        String NMR_STATS_METHOD = "getNMRStats";
        try {
            tabularResult = (TabularData)this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), NMR_STATS_METHOD, new Object[]{targetName}, new String[]{"java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
        return tabularResult;
    }

    public String getServiceAssemblyStatistics(String assemblyName, String targetName) throws ManagementRemoteException {
        String xmlText = null;
        Map map = null;
        TabularData tabularResult = this.getServiceAssemblyStatisticsAsTabularData(assemblyName, targetName);
        if (tabularResult != null) {
            map = ServiceAssemblyStatisticsData.retrieveDataMap((TabularData)tabularResult);
            xmlText = ServiceAssemblyStatisticsData.convertDataMapToXML((Map)map);
        }
        return xmlText;
    }

    public TabularData getServiceAssemblyStatisticsAsTabularData(String assemblyName, String targetName) throws ManagementRemoteException {
        TabularData tabularResult = null;
        String SA_STATS_METHOD = "getServiceAssemblyStats";
        try {
            tabularResult = (TabularData)this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), SA_STATS_METHOD, new Object[]{assemblyName, targetName}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
        return tabularResult;
    }

    public TabularData getConsumingEndpointsForComponentAsTabularData(String componentName, String targetName) throws ManagementRemoteException {
        TabularData tabularResult = null;
        String ENDPOINTS_LIST_METHOD = "getConsumingEndpointsForComponent";
        try {
            tabularResult = (TabularData)this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), ENDPOINTS_LIST_METHOD, new Object[]{componentName, targetName}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
        return tabularResult;
    }

    public TabularData getProvidingEndpointsForComponentAsTabularData(String componentName, String targetName) throws ManagementRemoteException {
        TabularData tabularResult = null;
        String ENDPOINTS_LIST_METHOD = "getProvidingEndpointsForComponent";
        try {
            tabularResult = (TabularData)this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), ENDPOINTS_LIST_METHOD, new Object[]{componentName, targetName}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
        return tabularResult;
    }

    public void enableMessageExchangeMonitoring(String targetName) throws ManagementRemoteException {
        String ENABLE_TIMINGS_METHOD = "enableMessageExchangeMonitoring";
        try {
            this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), ENABLE_TIMINGS_METHOD, new Object[]{targetName}, new String[]{"java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
    }

    public void disableMessageExchangeMonitoring(String targetName) throws ManagementRemoteException {
        String DISABLE_TIMINGS_METHOD = "disableMessageExchangeMonitoring";
        try {
            this.invokeMBeanOperation(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName(), DISABLE_TIMINGS_METHOD, new Object[]{targetName}, new String[]{"java.lang.String"});
        }
        catch (MalformedObjectNameException me) {
            throw new ManagementRemoteException((Throwable)me);
        }
    }
}

