/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging.stats;

public class Value {
    private double sum;
    private double squaredsum;
    private long min;
    private long max;
    private long count;

    public void zero() {
        this.sum = 0.0;
        this.squaredsum = 0.0;
        this.min = 0L;
        this.max = 0L;
        this.count = 0L;
    }

    public void addSample(long sample) {
        if (sample < this.min || this.count == 0L) {
            this.min = sample;
        }
        if (sample > this.max || this.count == 0L) {
            this.max = sample;
        }
        ++this.count;
        this.sum += (double)sample;
        this.squaredsum += (double)sample * (double)sample;
    }

    public double getAverage() {
        return this.sum / (double)this.count;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getCount() {
        return this.count;
    }

    public double getSd() {
        return Math.sqrt(1.0 / (double)(this.count - 1L) * (this.squaredsum - this.sum * this.sum / (double)this.count));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Count(" + this.count + ")");
        sb.append("Min(" + this.min + ")");
        sb.append("Avg(" + this.getAverage() + ")");
        sb.append("Max(" + this.max + ")");
        sb.append("Std(" + this.getSd() + ")");
        return sb.toString();
    }
}

