/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import java.util.Date;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class MessagingStatistics {
    private int mActiveExchanges;
    private long mInOnlyExchanges;
    private long mRobustInOnlyExchanges;
    private long mInOptionalOutExchanges;
    private long mInOutExchanges;
    private long mTotalExchangeTimeToClose;
    private long mFailedExchanges;
    private long mTransactedExchanges;
    private long mSends;
    private long mSendSyncs;
    private long mAccepts;
    private long mAcceptTimeouts;
    private long mFaultedExchanges;
    private Date mLastRestartTime;
    private static final int ONE_HUNDRED = 100;
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final String[] ITEM_NAMES = new String[]{"ActiveExchanges", "ActiveExchangeRate", "InOnlyExchanges", "RobustInOnlyExchanges", "InOptionalOutExchanges", "InOutExchanges", "ExchangeMeanTimeToClose", "ExchangeSuccessRate", "FailedExchanges", "TransactedExchanges", "FaultedExchanges", "SentExchanges", "SynchronousSentExchanges", "AcceptExchanges", "AcceptExchangesTimeout"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"Number of message exchanges currently active", "Current rate of active exchanges per hour", "Total number of InOnly message exchanges processed", "Total number of RobustInOnly message exchanges processed", "Total number of InOptionalOut message exchanges processed", "Total number of InOut message exchanges  processed", "Mean time to close a message exchange", "Message exchange success rate", "Total number of failed message exchanges", "Total number of transacted message exchanges", "Total number of faulted message exchanges", "Total number of message exchange send operations", "Total number of message exchange sendSync operations", "Total number of message exchange accept operations", "Total number of message exchange accept timeouts"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.DOUBLE, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.FLOAT, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
    private static CompositeType sMessagingStatisticsType;

    public MessagingStatistics() {
        try {
            sMessagingStatisticsType = new CompositeType("MessagingStatistics", "Message exchange statistics", ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
        }
        catch (OpenDataException openDataException) {
            // empty catch block
        }
    }

    public Date getLastRestartTime() {
        return this.mLastRestartTime;
    }

    public int getActiveExchanges() {
        return this.mActiveExchanges;
    }

    public double getActiveExchangeRate() {
        double totalExchanges = this.mInOnlyExchanges + this.mRobustInOnlyExchanges + this.mInOptionalOutExchanges + this.mInOutExchanges;
        long totalTime = new Date().getTime() - this.mLastRestartTime.getTime();
        double totalHours = totalTime / 3600000L;
        double exchangeRate = 0.0;
        if (0.0 < totalExchanges && 0.0 < totalHours) {
            exchangeRate = totalExchanges / totalHours;
        }
        return exchangeRate;
    }

    public long getInOnlyExchanges() {
        return this.mInOnlyExchanges;
    }

    public long getRobustInOnlyExchanges() {
        return this.mRobustInOnlyExchanges;
    }

    public long getInOptionalOutExchanges() {
        return this.mInOptionalOutExchanges;
    }

    public long getInOutExchanges() {
        return this.mInOutExchanges;
    }

    public long getTotalExchanges() {
        return this.mInOnlyExchanges + this.mRobustInOnlyExchanges + this.mInOptionalOutExchanges + this.mInOutExchanges;
    }

    public long getTotalExchangeTimeToClose() {
        return this.mTotalExchangeTimeToClose;
    }

    public long getExchangeMeanTimeToClose() {
        long totalTime = this.mTotalExchangeTimeToClose;
        long totalExchanges = this.mInOnlyExchanges + this.mRobustInOnlyExchanges + this.mInOptionalOutExchanges + this.mInOutExchanges;
        long meanTime = 0L;
        if (0L < totalExchanges) {
            meanTime = totalTime / totalExchanges;
        }
        return meanTime;
    }

    public long getFailedExchanges() {
        return this.mFailedExchanges;
    }

    public long getFaultedExchanges() {
        return this.mFaultedExchanges;
    }

    public long getSendExchanges() {
        return this.mSends;
    }

    public long getSendSyncExchanges() {
        return this.mSendSyncs;
    }

    public long getAcceptExchanges() {
        return this.mAccepts;
    }

    public long getAcceptTimeoutExchanges() {
        return this.mAcceptTimeouts;
    }

    public long getTransactedExchanges() {
        return this.mTransactedExchanges;
    }

    public float getExchangeSuccessRate() {
        if (0L == this.mFailedExchanges) {
            return 100.0f;
        }
        long failedExchanges = this.mFailedExchanges;
        long totalExchanges = this.mInOnlyExchanges + this.mRobustInOnlyExchanges + this.mInOptionalOutExchanges + this.mInOutExchanges;
        float successRate = (totalExchanges - failedExchanges) / totalExchanges * 100L;
        return successRate;
    }

    public synchronized void decrementActiveExchanges() {
        --this.mActiveExchanges;
    }

    public synchronized void incrementActiveExchanges() {
        ++this.mActiveExchanges;
    }

    public synchronized void incrementInOnlyExchanges() {
        ++this.mInOnlyExchanges;
    }

    public synchronized void incrementRobustInOnlyExchanges() {
        ++this.mRobustInOnlyExchanges;
    }

    public synchronized void incrementInOptionalOutExchanges() {
        ++this.mInOptionalOutExchanges;
    }

    public synchronized void incrementInOutExchanges() {
        ++this.mInOutExchanges;
    }

    public synchronized void addTotalExchangeTimeToClose(long timeToClose) {
        this.mTotalExchangeTimeToClose += timeToClose;
    }

    public synchronized void incrementFailedExchanges() {
        ++this.mFailedExchanges;
    }

    public synchronized void incrementTransactedExchanges() {
        ++this.mTransactedExchanges;
    }

    public synchronized void setLastRestartTime(Date restartTime) {
        this.mLastRestartTime = restartTime;
    }

    public synchronized void incrementSends() {
        ++this.mSends;
    }

    public synchronized void incrementSendSyncs() {
        ++this.mSendSyncs;
    }

    public synchronized void incrementAccepts() {
        ++this.mAccepts;
    }

    public synchronized void incrementAcceptTimeouts() {
        ++this.mAcceptTimeouts;
    }

    public synchronized void incrementFaults() {
        ++this.mFaultedExchanges;
    }

    public synchronized void resetStatistics() {
        this.mActiveExchanges = 0;
        this.mInOnlyExchanges = 0L;
        this.mRobustInOnlyExchanges = 0L;
        this.mInOptionalOutExchanges = 0L;
        this.mInOutExchanges = 0L;
        this.mTotalExchangeTimeToClose = 0L;
        this.mFailedExchanges = 0L;
        this.mTransactedExchanges = 0L;
        this.mSends = 0L;
        this.mSendSyncs = 0L;
        this.mAccepts = 0L;
        this.mAcceptTimeouts = 0L;
        this.mFaultedExchanges = 0L;
        this.mLastRestartTime = new Date();
    }

    public CompositeData toCompositeData() throws OpenDataException {
        Object[] values = new Object[]{this.getActiveExchanges(), this.getActiveExchangeRate(), this.getInOnlyExchanges(), this.getRobustInOnlyExchanges(), this.getInOptionalOutExchanges(), this.getInOutExchanges(), this.getExchangeMeanTimeToClose(), Float.valueOf(this.getExchangeSuccessRate()), this.getFailedExchanges(), this.getTransactedExchanges(), this.getFaultedExchanges(), this.getSendExchanges(), this.getSendSyncExchanges(), this.getAcceptExchanges(), this.getAcceptTimeoutExchanges()};
        return new CompositeDataSupport(sMessagingStatisticsType, ITEM_NAMES, values);
    }
}

