/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.ChannelStatistics;
import com.sun.jbi.messaging.EndpointStatistics;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.messaging.MessageServiceStatisticsMBean;
import com.sun.jbi.messaging.MessagingStatistics;
import com.sun.jbi.monitoring.StatisticsBase;
import com.sun.jbi.util.monitoring.StatisticsBaseImpl;
import java.util.Date;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public class MessageServiceStatistics
implements MessageServiceStatisticsMBean,
NotificationListener {
    private MessageService mMsgSvc;
    private StatisticsBase mStatisticsBase;
    private Date mLastRestartTime;
    private int mRegisteredServices;
    private int mRegisteredEndpoints;
    private MessagingStatistics mMessagingStatistics;
    private static final int ONE_HUNDRED = 100;
    private static final int MILLISECONDS_PER_HOUR = 3600000;

    MessageServiceStatistics(MessageService msgSvc, String key) {
        this.mMsgSvc = msgSvc;
        this.mStatisticsBase = new StatisticsBaseImpl(key);
        this.mMessagingStatistics = new MessagingStatistics();
    }

    public void setDisabled() {
        this.mMsgSvc.disableStatistics();
    }

    @Override
    public void disableTimingStatistics() {
        this.mMsgSvc.disableStatistics();
    }

    public boolean isEnabled() {
        return this.mMsgSvc.areStatisticsEnabled();
    }

    public void setEnabled() {
        this.mMsgSvc.enableStatistics();
    }

    @Override
    public void enableTimingStatistics() {
        this.mMsgSvc.enableStatistics();
    }

    @Override
    public Date getLastRestartTime() {
        return this.mLastRestartTime;
    }

    @Override
    public int getRegisteredServices() {
        return this.mRegisteredServices;
    }

    @Override
    public int getRegisteredEndpoints() {
        return this.mRegisteredEndpoints;
    }

    @Override
    public String[] getActiveChannels() {
        return this.mMsgSvc.getChannelNames();
    }

    @Override
    public String[] getActiveEndpoints() {
        return this.mMsgSvc.getEndpointNames();
    }

    @Override
    public String[] getEndpointsForDeliveryChannel(String dcName) {
        return this.mMsgSvc.getActiveEndpoints(dcName);
    }

    @Override
    public String[] getConsumingEndpointsForDeliveryChannel(String dcName) {
        return this.mMsgSvc.getActiveConsumingEndpoints(dcName);
    }

    @Override
    public CompositeData getMessagingStatistics() {
        CompositeData mscd = null;
        try {
            mscd = this.mMessagingStatistics.toCompositeData();
        }
        catch (OpenDataException odEx) {
            odEx.printStackTrace();
        }
        return mscd;
    }

    @Override
    public CompositeData getDeliveryChannelStatistics(String dcName) {
        CompositeData mscd = null;
        ChannelStatistics cs = this.mMsgSvc.getChannelStatistics(dcName);
        if (cs != null) {
            mscd = cs.getStatistics();
        }
        return mscd;
    }

    @Override
    public CompositeData getEndpointStatistics(String epName) {
        CompositeData mscd = null;
        EndpointStatistics es = this.mMsgSvc.getEndpointStatistics(epName);
        if (es != null) {
            mscd = es.getStatistics();
        }
        return mscd;
    }

    @Override
    public TabularData getHistoricalEndpointStatistics(String epName) {
        TabularData mscd = null;
        EndpointStatistics es = this.mMsgSvc.getEndpointStatistics(epName);
        if (es != null) {
            mscd = es.getHistoricalStatistics();
        }
        return mscd;
    }

    MessagingStatistics getMessagingStatisticsInstance() {
        return this.mMessagingStatistics;
    }

    StatisticsBase getStatisticsBase() {
        return this.mStatisticsBase;
    }

    void setLastRestartTime(Date startTime) {
        this.mLastRestartTime = startTime;
        this.mMessagingStatistics.setLastRestartTime(startTime);
    }

    void decrementRegisteredEndpoints() {
        --this.mRegisteredEndpoints;
    }

    void incrementRegisteredEndpoints() {
        ++this.mRegisteredEndpoints;
    }

    void decrementRegisteredServices() {
        --this.mRegisteredServices;
    }

    void incrementRegisteredServices() {
        ++this.mRegisteredServices;
    }

    @Override
    public void resetStatistics() {
        this.mRegisteredServices = 0;
        this.mRegisteredEndpoints = 0;
        this.mMessagingStatistics.resetStatistics();
        if (this.mMsgSvc != null) {
            this.mMsgSvc.zeroStatistics();
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification notif = (AttributeChangeNotification)notification;
            Boolean enableTimingStatsStr = (Boolean)notif.getNewValue();
            boolean enableTimingStats = enableTimingStatsStr;
            if (enableTimingStats) {
                this.enableTimingStatistics();
            } else {
                this.disableTimingStatistics();
            }
        }
    }
}

