/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.Link;
import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.stats.METimestamps;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.xml.namespace.QName;

public class LinkedEndpoint
extends RegisteredEndpoint {
    private static final String OWNER_ID = "<NotKnownYet>";
    private QName mServiceLink;
    private String mEndpointLink;
    private Link mLinkType;
    private static final int ITEMS_BASE = 13;
    private static final int ITEMS_EXTRA = 16;
    private static final String[] ITEM_NAMES = new String[]{"OwningChannel", "ActiveExchanges", "SendRequest", "ReceiveReply", "SendFault", "ReceiveFault", "LastFaultTime", "SendDONE", "ReceiveDONE", "LastDONETime", "SendERROR", "ReceiveERROR", "LastERRORTime", "StatusTimeMin (ns)", "StatusTimeAvg (ns)", "StatusTimeMax (ns)", "StatusTimeStd (ns)", "NMRTimeMin (ns)", "NMRTimeAvg (ns)", "NMRTimeMax (ns)", "NMRTimeStd (ns)", "ComponentTimeMin (ns)", "ComponentTimeAvg (ns)", "ComponentTimeMax (ns)", "ComponentTimeStd (ns)", "ChannelTimeMin (ns)", "ChannelTimeAvg (ns)", "ChannelTimeMax (ns)", "ChannelTimeStd (ns)"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"Owning DeliveryChannel", "Active Exchanges", "Number of requests sent", "Number of replies received", "Number of faults sent", "Number of faults received", "Timestamp of last fault", "Number of DONE requests sent", "Number of DONE requests received", "Timestamp of last DONE", "Number of ERROR requests sent", "Number of ERROR requests received", "Timestamp of last ERROR", "Status Time Min", "Status Time Avg", "Status Time Max", "Status Time Std", "NMR Time Min", "NMR Time Avg", "NMR Time Max", "NMR Time Std", "Component Time Min", "Component Time Avg", "Component Time Max", "Component Time Std", "Channel Time Min", "Channel Time Avg", "Channel Time Max", "Channel Time Std"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};

    public LinkedEndpoint(QName fromService, String fromEndpoint, QName toService, String toEndpoint, Link linkType) {
        super(fromService, fromEndpoint, OWNER_ID);
        this.mLinkType = linkType;
        this.mServiceLink = toService;
        this.mEndpointLink = toEndpoint;
    }

    @Override
    public int getType() {
        return 40;
    }

    public String getEndpointLink() {
        return this.mEndpointLink;
    }

    public QName getServiceLink() {
        return this.mServiceLink;
    }

    public void setInUse(String ownerId) {
        this.mActiveExchanges.incrementAndGet();
        if (this.mOwnerId.equals(OWNER_ID)) {
            this.mOwnerId = ownerId;
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && this.getClass() == obj.getClass()) {
            LinkedEndpoint le = (LinkedEndpoint)obj;
            isEqual = this.mLinkType == le.mLinkType && this.mEndpointLink.equals(le.mEndpointLink) && this.mServiceLink.equals(le.mServiceLink) && this.getEndpointName().equals(le.getEndpointName()) && this.getServiceName().equals(le.getServiceName());
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        return this.mServiceLink.hashCode() ^ this.mEndpointLink.hashCode() ^ super.hashCode();
    }

    @Override
    synchronized void updateStatistics(MessageExchangeProxy me) {
        int mask = me.getPhaseMask();
        METimestamps ts = me.getTimestamps();
        if ((mask & 0x800) != 0) {
            ++this.mReceiveReply;
        }
        if ((mask & 0x10) != 0) {
            ++this.mSendFault;
            this.mLastFaultTime = System.currentTimeMillis();
        }
        if ((mask & 1) != 0) {
            ++this.mSendDONE;
            this.mLastDONETime = System.currentTimeMillis();
        }
        if ((mask & 2) != 0) {
            ++this.mSendERROR;
            this.mLastERRORTime = System.currentTimeMillis();
        }
        if ((mask & 4) != 0) {
            ++this.mSendRequest;
        }
        if ((mask & 0x1000) != 0) {
            ++this.mReceiveFault;
            this.mLastFaultTime = System.currentTimeMillis();
        }
        if ((mask & 0x100) != 0) {
            ++this.mReceiveDONE;
            this.mLastDONETime = System.currentTimeMillis();
        }
        if ((mask & 0x200) != 0) {
            ++this.mReceiveERROR;
            this.mLastERRORTime = System.currentTimeMillis();
        }
        if (ts != null) {
            this.mStatusTime.addSample(ts.mStatusTime);
            this.mNMRTime.addSample(ts.mNMRTime);
            this.mChannelTime.addSample(ts.mProviderChannelTime);
            this.mComponentTime.addSample(ts.mProviderTime);
        }
    }

    @Override
    public String getName() {
        return this.toExternalName();
    }

    @Override
    public CompositeData getStatistics() {
        try {
            String[] descs;
            String[] names;
            OpenType[] types;
            Object[] values;
            boolean enabled;
            boolean bl = enabled = this.mChannelTime.getCount() != 0L;
            if (enabled) {
                values = new Object[29];
                types = ITEM_TYPES;
                names = ITEM_NAMES;
                descs = ITEM_DESCRIPTIONS;
            } else {
                values = new Object[13];
                types = new OpenType[13];
                System.arraycopy(ITEM_TYPES, 0, types, 0, 13);
                names = new String[13];
                System.arraycopy(ITEM_NAMES, 0, names, 0, 13);
                descs = new String[13];
                System.arraycopy(ITEM_DESCRIPTIONS, 0, descs, 0, 13);
            }
            values[0] = this.mOwnerId;
            values[1] = this.mActiveExchanges.get();
            values[2] = this.mSendRequest;
            values[3] = this.mReceiveReply;
            values[4] = this.mSendFault;
            values[5] = this.mReceiveFault;
            values[6] = this.mLastFaultTime;
            values[7] = this.mSendDONE;
            values[8] = this.mReceiveDONE;
            values[9] = this.mLastDONETime;
            values[10] = this.mSendERROR;
            values[11] = this.mReceiveERROR;
            values[12] = this.mLastERRORTime;
            if (enabled) {
                values[13] = this.mStatusTime.getMin();
                values[14] = (long)this.mStatusTime.getAverage();
                values[15] = this.mStatusTime.getMax();
                values[16] = (long)this.mStatusTime.getSd();
                values[17] = this.mNMRTime.getMin();
                values[18] = (long)this.mNMRTime.getAverage();
                values[19] = this.mNMRTime.getMax();
                values[20] = (long)this.mNMRTime.getSd();
                values[21] = this.mComponentTime.getMin();
                values[22] = (long)this.mComponentTime.getAverage();
                values[23] = this.mComponentTime.getMax();
                values[24] = (long)this.mComponentTime.getSd();
                values[25] = this.mChannelTime.getMin();
                values[26] = (long)this.mChannelTime.getAverage();
                values[27] = this.mChannelTime.getMax();
                values[28] = (long)this.mChannelTime.getSd();
            }
            return new CompositeDataSupport(new CompositeType("EndpointStatistics", "Endpoint statistics", names, descs, types), names, values);
        }
        catch (OpenDataException openDataException) {
            return null;
        }
    }

    @Override
    public String toStringBrief() {
        StringBuilder sb = new StringBuilder();
        sb.append("        EndPoint Type: Linked\n");
        sb.append(super.toStringBrief());
        sb.append("          LinkedService: ");
        sb.append(this.mServiceLink == null ? "Null" : this.mServiceLink);
        sb.append(",\n          LinkedEndpoint: ");
        sb.append(this.mEndpointLink == null ? "Null" : this.mEndpointLink);
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringBrief());
        sb.append("            SendRequest: " + this.mSendRequest);
        sb.append("  ReceiveReply: " + this.mReceiveReply);
        sb.append("\n            RecvDONE: " + this.mReceiveDONE);
        sb.append("  SendDONE: " + this.mSendDONE);
        sb.append("\n            RecvERROR: " + this.mReceiveERROR);
        sb.append("  SendERROR: " + this.mSendERROR);
        sb.append("\n            RecvFault: " + this.mReceiveFault);
        sb.append("  SendFault: " + this.mSendFault);
        sb.append("\n");
        if (this.mChannelTime.getCount() != 0L) {
            sb.append("            StatusTime:  " + this.mStatusTime.toString());
            sb.append("\n            ComponentTime: " + this.mComponentTime.toString());
            sb.append("\n            ChannelTime:   " + this.mChannelTime.toString());
            sb.append("\n            NMRTime:       " + this.mNMRTime.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

