/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import java.net.URI;
import java.net.URISyntaxException;

public enum ExchangePattern {
    IN_ONLY("http://www.w3.org", "2004/08", "in-only"),
    IN_OUT("http://www.w3.org", "2004/08", "in-out"),
    ROBUST_IN_ONLY("http://www.w3.org", "2004/08", "robust-in-only"),
    IN_OPTIONAL_OUT("http://www.w3.org", "2004/08", "in-opt-out"),
    UNKNOWN("", "", "");

    private String mPatternStr;
    private URI mPatternUri;

    private ExchangePattern(String uriRoot, String version, String mep) {
        this.mPatternStr = uriRoot + "/" + version + "/wsdl/" + mep;
        try {
            this.mPatternUri = new URI(this.mPatternStr);
        }
        catch (URISyntaxException uriEx) {
            throw new IllegalArgumentException(this.mPatternStr, uriEx);
        }
    }

    public String toString() {
        return this.mPatternStr;
    }

    public URI getURI() {
        return this.mPatternUri;
    }

    public static ExchangePattern valueOf(URI pattern) {
        String mep = pattern.toString();
        if (!mep.startsWith("http://www.w3.org/")) {
            return UNKNOWN;
        }
        if (mep.endsWith("/in-only")) {
            return IN_ONLY;
        }
        if (mep.endsWith("/in-out")) {
            return IN_OUT;
        }
        if (mep.endsWith("/robust-in-only")) {
            return ROBUST_IN_ONLY;
        }
        if (mep.endsWith("/in-opt-out")) {
            return IN_OPTIONAL_OUT;
        }
        return UNKNOWN;
    }
}

