/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.ExchangeIdGenerator;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.Enumeration;

public final class ExchangeIdGeneratorImpl
implements ExchangeIdGenerator {
    long mLastTimestamp;
    int mCounter;
    int mSequence;
    long mNode;
    private static final long CLOCK_OFFSET = 122192928000000000L;
    private static final int CLOCK_SCALE = 10000;
    private SecureRandom mRandom = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextId() {
        int counter;
        int sequence;
        long node;
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder(40);
        ExchangeIdGeneratorImpl exchangeIdGeneratorImpl = this;
        synchronized (exchangeIdGeneratorImpl) {
            node = this.mNode;
            sequence = this.mSequence;
            if (this.mNode == 0L || now < this.mLastTimestamp) {
                this.initialize();
                node = this.mNode;
                sequence = this.mSequence;
            } else if (now == this.mLastTimestamp) {
                if (this.mCounter == 10000) {
                    this.mCounter &= 0xFF;
                    do {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    } while ((now = System.currentTimeMillis()) == this.mLastTimestamp);
                }
            } else {
                this.mCounter &= 0xFF;
            }
            this.mLastTimestamp = now;
            counter = ++this.mCounter;
        }
        sb.append(node);
        sb.append('-');
        sb.append(sequence);
        sb.append('-');
        sb.append(now * 10000L + 122192928000000000L + (long)counter);
        return sb.toString();
    }

    private void initialize() {
        if (this.mNode == 0L) {
            this.mRandom.nextBytes(new byte[16]);
            try {
                Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
                while (eni.hasMoreElements()) {
                    NetworkInterface ni = eni.nextElement();
                    Enumeration<InetAddress> eia = ni.getInetAddresses();
                    while (eia.hasMoreElements()) {
                        InetAddress ia = eia.nextElement();
                        this.mRandom.setSeed(ia.getAddress());
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.mNode = this.mRandom.nextLong() & 0xFFFFFFFFFFFFL;
        }
        this.mCounter = this.mRandom.nextInt() & 0xFF;
        this.mSequence = this.mRandom.nextInt() & 0xFFFF;
    }
}

