/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.DOMUtil;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.common.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceUnitInfo {
    public static final String UNKNOWN_STATE = "Unknown";
    public static final String SHUTDOWN_STATE = "Shutdown";
    public static final String STARTED_STATE = "Started";
    public static final String STOPPED_STATE = "Stopped";
    private String mName;
    private String mDescription;
    private String mDeployedOn;
    private String mState;

    public ServiceUnitInfo() {
        this("", "", "", UNKNOWN_STATE);
    }

    public ServiceUnitInfo(String name, String description, String deployedOn, String state) {
        this.mName = name;
        this.mDescription = description;
        this.mDeployedOn = deployedOn;
        this.mState = state;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getTargetName() {
        return this.getDeployedOn();
    }

    public String getDeployedOn() {
        return this.mDeployedOn;
    }

    public void setDeployedOn(String deployedOn) {
        this.mDeployedOn = deployedOn;
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String state) {
        this.mState = state;
    }

    public String getLocalizedState() {
        String localizedState = Util.getCommonI18NBundle().getMessage(this.getState());
        return localizedState;
    }

    public String toString() {
        return "Name = " + this.getName() + "\nDescription = " + this.getDescription() + "\nState = " + this.getState() + "\nDeployed On = " + this.getDeployedOn();
    }

    public String toXmlString() {
        return "<service-unit-info \nname=\"" + this.getName() + "\" \n" + "state=\"" + this.getState() + "\" \n" + "deployed-on=\"" + this.getDeployedOn() + "\" >\n" + "<description>" + this.getDescription() + "</description> \n" + "</service-unit-info>";
    }

    public static ServiceUnitInfo createServiceUnitInfo(Element suInfoEl) {
        ServiceUnitInfo info = new ServiceUnitInfo();
        if (suInfoEl == null) {
            return null;
        }
        String name = suInfoEl.getAttribute("name");
        info.setName(name);
        String state = suInfoEl.getAttribute("state");
        info.setState(state);
        String deployedOn = suInfoEl.getAttribute("deployed-on");
        info.setDeployedOn(deployedOn);
        String desc = null;
        Element descEl = DOMUtil.UTIL.getElement(suInfoEl, "description");
        if (descEl != null) {
            desc = DOMUtil.UTIL.getTextData(descEl);
        }
        info.setDescription(desc);
        return info;
    }

    public static List createServiceUnitInfoList(NodeList suInfoElList) {
        ArrayList<ServiceUnitInfo> suInfoList = new ArrayList<ServiceUnitInfo>();
        if (suInfoElList == null) {
            return suInfoList;
        }
        int size = suInfoElList.getLength();
        for (int i = 0; i < size; ++i) {
            Element suInfoEl = (Element)suInfoElList.item(i);
            if (suInfoEl == null) continue;
            ServiceUnitInfo suInfo = ServiceUnitInfo.createServiceUnitInfo(suInfoEl);
            suInfoList.add(suInfo);
        }
        ServiceUnitInfo.sort(suInfoList);
        return suInfoList;
    }

    public static String writeAsXmlText(List suInfoList) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        if (suInfoList != null) {
            int size = suInfoList.size();
            for (int i = 0; i < size; ++i) {
                ServiceUnitInfo info = (ServiceUnitInfo)suInfoList.get(i);
                writer.println(info.toXmlString());
            }
        }
        try {
            writer.close();
            stringWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static ServiceUnitInfo createFromServiceUnitDD(ServiceAssemblyDD.ServiceUnitDD suDD) {
        ServiceUnitInfo suInfo = new ServiceUnitInfo();
        suInfo.setName(suDD.getName());
        suInfo.setDescription(suDD.getDescription());
        suInfo.setDeployedOn(suDD.getTargetName());
        return suInfo;
    }

    public static void sort(List suInfoList) {
        try {
            Collections.sort(suInfoList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ServiceUnitInfo)o1).getName().compareTo(((ServiceUnitInfo)o2).getName());
                }
            });
        }
        catch (ClassCastException ccEx) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

