/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarFactory {
    private byte[] mBuffer;
    private String mDir;

    public JarFactory(String dir) {
        this.mDir = dir;
        this.mBuffer = new byte[8092];
    }

    public void unJar(File jarFile) throws IOException, JarException, ZipException {
        JarFile jar = new JarFile(jarFile);
        this.unJar(jar);
        jar.close();
    }

    public void unJar(ZipFile jar) throws IOException, ZipException {
        Enumeration<? extends ZipEntry> all = jar.entries();
        while (all.hasMoreElements()) {
            this.getEntry(jar, all.nextElement());
        }
    }

    public String getEntry(ZipFile jarFile, ZipEntry entry) throws IOException {
        String entryName = entry.getName();
        if (entryName.endsWith("/")) {
            new File(this.mDir, entryName).mkdirs();
            return entryName;
        }
        File f = new File(this.mDir, entryName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream fostream = new FileOutputStream(f);
        InputStream istream = jarFile.getInputStream(entry);
        int n = 0;
        while ((n = istream.read(this.mBuffer)) > 0) {
            fostream.write(this.mBuffer, 0, n);
        }
        try {
            istream.close();
            fostream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryName;
    }

    public String zip(String zipFileName) throws IOException {
        String[] filesToAdd;
        File dir = new File(this.mDir);
        File zipFile = new File(dir.getParent(), zipFileName);
        ZipOutputStream outstream = new ZipOutputStream(new FileOutputStream(zipFile));
        for (String filesToAdd1 : filesToAdd = dir.list()) {
            int len;
            FileInputStream inStream = new FileInputStream(new File(dir, filesToAdd1));
            outstream.putNextEntry(new ZipEntry(filesToAdd1));
            while ((len = inStream.read(this.mBuffer)) > 0) {
                outstream.write(this.mBuffer, 0, len);
            }
            outstream.closeEntry();
            inStream.close();
        }
        outstream.close();
        return zipFile.getPath();
    }
}

