/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.JBIDescriptor;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JBIArchive {
    private JarFile mJarFile;
    private JBIDescriptor mJbiDescriptor;

    public JBIArchive(String pathName) throws IOException {
        this(new File(pathName));
    }

    public JBIArchive(File file) throws IOException {
        this(new JarFile(file));
    }

    public JBIArchive(JarFile jarFile) throws IOException {
        this.mJarFile = jarFile;
        this.validate();
    }

    private void validate() throws IOException {
        try {
            JBIDescriptor jbiDD = this.getJbiDescriptor();
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public JarFile getJarFile() throws IOException {
        return this.mJarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBIDescriptor getJbiDescriptor() throws Exception {
        if (this.mJbiDescriptor == null) {
            JarEntry jbiXmlEntry = this.mJarFile.getJarEntry("META-INF/jbi.xml");
            if (jbiXmlEntry != null) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(this.mJarFile.getInputStream(jbiXmlEntry));
                    this.mJbiDescriptor = JBIDescriptor.createJBIDescriptor(reader);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception ex) {}
                    }
                    try {
                        this.mJarFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            throw new IOException(JBIResultXmlBuilder.createFailedJbiResultXml(Util.getCommonI18NBundle(), "jbi.xml.not.found.in.jbi.archive", null));
        }
        return this.mJbiDescriptor;
    }

    public boolean isSharedLibraryArchive() {
        try {
            JBIDescriptor jbiDesc = this.getJbiDescriptor();
            return jbiDesc != null && jbiDesc.isSharedLibraryDescriptor();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isServiceAssemblyArchive() {
        try {
            JBIDescriptor jbiDesc = this.getJbiDescriptor();
            return jbiDesc != null && jbiDesc.isServiceAssemblyDescriptor();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isServiceEngineArchive() {
        try {
            JBIDescriptor jbiDesc = this.getJbiDescriptor();
            return jbiDesc != null && jbiDesc.isServiceEngineDescriptor();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isBindingComponentArchive() {
        try {
            JBIDescriptor jbiDesc = this.getJbiDescriptor();
            return jbiDesc != null && jbiDesc.isBindingComponentDescriptor();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

