/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.deployment;

import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.base.services.BaseServiceImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import java.io.Serializable;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DeploymentServiceImpl
extends BaseServiceImpl
implements Serializable,
DeploymentService {
    static final long serialVersionUID = -1L;

    public DeploymentServiceImpl() {
        super(null, false);
    }

    public DeploymentServiceImpl(MBeanServerConnection serverConnection) {
        super(serverConnection, false);
    }

    public DeploymentServiceImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        super(serverConnection, isRemoteConnection);
    }

    @Override
    public String deployServiceAssembly(String zipFilePath, String targetName) throws ManagementRemoteException {
        String result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Object resultObject = null;
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{zipFilePath, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "deployServiceAssembly", params, signature);
        this.removeUploadedFile();
        result = resultObject.toString();
        return result;
    }

    @Override
    public Map<String, String> deployServiceAssembly(String zipFilePath, String[] targetNames) throws ManagementRemoteException {
        Map result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{zipFilePath, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        result = (Map)this.invokeMBeanOperation(mbeanName, "deployServiceAssembly", params, signature);
        this.removeUploadedFile();
        return result;
    }

    @Override
    public String deployServiceAssemblyFromDomain(String assemblyName, String targetName) throws ManagementRemoteException {
        String result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Object[] params = new Object[]{assemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        result = (String)this.invokeMBeanOperation(mbeanName, "deployServiceAssemblyFromDomain", params, signature);
        return result;
    }

    @Override
    public Map<String, String> deployServiceAssemblyFromDomain(String assemblyName, String[] targetNames) throws ManagementRemoteException {
        Map result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Object[] params = new Object[]{assemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        result = (Map)this.invokeMBeanOperation(mbeanName, "deployServiceAssemblyFromDomain", params, signature);
        return result;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        String result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, retainInDomain, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", "java.lang.String"};
        result = (String)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return result;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String targetName) throws ManagementRemoteException {
        String result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        result = (String)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return result;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        String result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        result = (String)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return result;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        Map result = null;
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        result = (Map)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return result;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getDeploymentServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, retainInDomain, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject;
    }
}

